/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.StaticCidrsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.StaticCidrInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.StaticCidrList;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class StaticCidrsClientImpl
implements StaticCidrsClient {
    private final StaticCidrsService service;
    private final NetworkManagementClientImpl client;

    StaticCidrsClientImpl(NetworkManagementClientImpl client) {
        this.service = RestProxy.create(StaticCidrsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<StaticCidrInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, String poolName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, poolName, skipToken, skip, top, sortKey, sortValue, "2024-05-01", "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, StaticCidrInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticCidrList)res.getValue()).value(), ((StaticCidrList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<StaticCidrInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, String poolName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, poolName, skipToken, skip, top, sortKey, sortValue, "2024-05-01", "application/json", context).map(res -> new PagedResponseBase<Object, StaticCidrInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticCidrList)res.getValue()).value(), ((StaticCidrList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<StaticCidrInner> listAsync(String resourceGroupName, String networkManagerName, String poolName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue) {
        return new PagedFlux<StaticCidrInner>(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, poolName, skipToken, skip, top, sortKey, sortValue), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<StaticCidrInner> listAsync(String resourceGroupName, String networkManagerName, String poolName) {
        String skipToken = null;
        Integer skip = null;
        Integer top = null;
        String sortKey = null;
        String sortValue = null;
        return new PagedFlux<StaticCidrInner>(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, poolName, skipToken, skip, top, sortKey, sortValue), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<StaticCidrInner> listAsync(String resourceGroupName, String networkManagerName, String poolName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        return new PagedFlux<StaticCidrInner>(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, poolName, skipToken, skip, top, sortKey, sortValue, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<StaticCidrInner> list(String resourceGroupName, String networkManagerName, String poolName) {
        String skipToken = null;
        Integer skip = null;
        Integer top = null;
        String sortKey = null;
        String sortValue = null;
        return new PagedIterable<StaticCidrInner>(this.listAsync(resourceGroupName, networkManagerName, poolName, skipToken, skip, top, sortKey, sortValue));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<StaticCidrInner> list(String resourceGroupName, String networkManagerName, String poolName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        return new PagedIterable<StaticCidrInner>(this.listAsync(resourceGroupName, networkManagerName, poolName, skipToken, skip, top, sortKey, sortValue, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StaticCidrInner>> createWithResponseAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName, StaticCidrInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (staticCidrName == null) {
            return Mono.error(new IllegalArgumentException("Parameter staticCidrName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, poolName, staticCidrName, "2024-05-01", body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StaticCidrInner>> createWithResponseAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName, StaticCidrInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (staticCidrName == null) {
            return Mono.error(new IllegalArgumentException("Parameter staticCidrName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, poolName, staticCidrName, "2024-05-01", body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StaticCidrInner> createAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName) {
        StaticCidrInner body = null;
        return this.createWithResponseAsync(resourceGroupName, networkManagerName, poolName, staticCidrName, body).flatMap(res -> Mono.justOrEmpty((StaticCidrInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StaticCidrInner> createWithResponse(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName, StaticCidrInner body, Context context) {
        return this.createWithResponseAsync(resourceGroupName, networkManagerName, poolName, staticCidrName, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StaticCidrInner create(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName) {
        StaticCidrInner body = null;
        return this.createWithResponse(resourceGroupName, networkManagerName, poolName, staticCidrName, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StaticCidrInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (staticCidrName == null) {
            return Mono.error(new IllegalArgumentException("Parameter staticCidrName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, poolName, staticCidrName, "2024-05-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StaticCidrInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (staticCidrName == null) {
            return Mono.error(new IllegalArgumentException("Parameter staticCidrName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, poolName, staticCidrName, "2024-05-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StaticCidrInner> getAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName) {
        return this.getWithResponseAsync(resourceGroupName, networkManagerName, poolName, staticCidrName).flatMap(res -> Mono.justOrEmpty((StaticCidrInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StaticCidrInner> getWithResponse(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, networkManagerName, poolName, staticCidrName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StaticCidrInner get(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName) {
        return this.getWithResponse(resourceGroupName, networkManagerName, poolName, staticCidrName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (staticCidrName == null) {
            return Mono.error(new IllegalArgumentException("Parameter staticCidrName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, poolName, staticCidrName, "2024-05-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (staticCidrName == null) {
            return Mono.error(new IllegalArgumentException("Parameter staticCidrName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, networkManagerName, poolName, staticCidrName, "2024-05-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkManagerName, poolName, staticCidrName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkManagerName, poolName, staticCidrName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, poolName, staticCidrName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, poolName, staticCidrName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, poolName, staticCidrName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, poolName, staticCidrName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName) {
        this.deleteAsync(resourceGroupName, networkManagerName, poolName, staticCidrName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String poolName, String staticCidrName, Context context) {
        this.deleteAsync(resourceGroupName, networkManagerName, poolName, staticCidrName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<StaticCidrInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, StaticCidrInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticCidrList)res.getValue()).value(), ((StaticCidrList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<StaticCidrInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, StaticCidrInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StaticCidrList)res.getValue()).value(), ((StaticCidrList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface StaticCidrsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools/{poolName}/staticCidrs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<StaticCidrList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkManagerName") String var4, @PathParam(value="poolName") String var5, @QueryParam(value="skipToken") String var6, @QueryParam(value="skip") Integer var7, @QueryParam(value="top") Integer var8, @QueryParam(value="sortKey") String var9, @QueryParam(value="sortValue") String var10, @QueryParam(value="api-version") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools/{poolName}/staticCidrs/{staticCidrName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<StaticCidrInner>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkManagerName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="staticCidrName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") StaticCidrInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools/{poolName}/staticCidrs/{staticCidrName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<StaticCidrInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkManagerName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="staticCidrName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/ipamPools/{poolName}/staticCidrs/{staticCidrName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="networkManagerName") String var4, @PathParam(value="poolName") String var5, @PathParam(value="staticCidrName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<StaticCidrList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

