/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ActiveDefaultSecurityAdminRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ActiveSecurityAdminRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConfigurationGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.EffectiveAdminRuleKind;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkManagerSecurityGroupItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class ActiveBaseSecurityAdminRule
implements JsonSerializable<ActiveBaseSecurityAdminRule> {
    private EffectiveAdminRuleKind kind = EffectiveAdminRuleKind.fromString("ActiveBaseSecurityAdminRule");
    private String id;
    private OffsetDateTime commitTime;
    private String region;
    private String configurationDescription;
    private String ruleCollectionDescription;
    private List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups;
    private List<ConfigurationGroup> ruleGroups;

    public EffectiveAdminRuleKind kind() {
        return this.kind;
    }

    public String id() {
        return this.id;
    }

    public ActiveBaseSecurityAdminRule withId(String id) {
        this.id = id;
        return this;
    }

    public OffsetDateTime commitTime() {
        return this.commitTime;
    }

    public ActiveBaseSecurityAdminRule withCommitTime(OffsetDateTime commitTime) {
        this.commitTime = commitTime;
        return this;
    }

    public String region() {
        return this.region;
    }

    public ActiveBaseSecurityAdminRule withRegion(String region) {
        this.region = region;
        return this;
    }

    public String configurationDescription() {
        return this.configurationDescription;
    }

    public ActiveBaseSecurityAdminRule withConfigurationDescription(String configurationDescription) {
        this.configurationDescription = configurationDescription;
        return this;
    }

    public String ruleCollectionDescription() {
        return this.ruleCollectionDescription;
    }

    public ActiveBaseSecurityAdminRule withRuleCollectionDescription(String ruleCollectionDescription) {
        this.ruleCollectionDescription = ruleCollectionDescription;
        return this;
    }

    public List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups() {
        return this.ruleCollectionAppliesToGroups;
    }

    public ActiveBaseSecurityAdminRule withRuleCollectionAppliesToGroups(List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups) {
        this.ruleCollectionAppliesToGroups = ruleCollectionAppliesToGroups;
        return this;
    }

    public List<ConfigurationGroup> ruleGroups() {
        return this.ruleGroups;
    }

    public ActiveBaseSecurityAdminRule withRuleGroups(List<ConfigurationGroup> ruleGroups) {
        this.ruleGroups = ruleGroups;
        return this;
    }

    public void validate() {
        if (this.ruleCollectionAppliesToGroups() != null) {
            this.ruleCollectionAppliesToGroups().forEach(e -> e.validate());
        }
        if (this.ruleGroups() != null) {
            this.ruleGroups().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("commitTime", this.commitTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.commitTime));
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("configurationDescription", this.configurationDescription);
        jsonWriter.writeStringField("ruleCollectionDescription", this.ruleCollectionDescription);
        jsonWriter.writeArrayField("ruleCollectionAppliesToGroups", this.ruleCollectionAppliesToGroups, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("ruleGroups", this.ruleGroups, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ActiveBaseSecurityAdminRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ActiveBaseSecurityAdminRule activeBaseSecurityAdminRule;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Custom".equals(discriminatorValue)) {
                    activeBaseSecurityAdminRule = ActiveSecurityAdminRule.fromJson(readerToUse.reset());
                    return activeBaseSecurityAdminRule;
                }
                if ("Default".equals(discriminatorValue)) {
                    activeBaseSecurityAdminRule = ActiveDefaultSecurityAdminRule.fromJson(readerToUse.reset());
                    return activeBaseSecurityAdminRule;
                }
                activeBaseSecurityAdminRule = ActiveBaseSecurityAdminRule.fromJsonKnownDiscriminator(readerToUse.reset());
                return activeBaseSecurityAdminRule;
            }
        });
    }

    static ActiveBaseSecurityAdminRule fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ActiveBaseSecurityAdminRule deserializedActiveBaseSecurityAdminRule = new ActiveBaseSecurityAdminRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedActiveBaseSecurityAdminRule.kind = EffectiveAdminRuleKind.fromString(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedActiveBaseSecurityAdminRule.id = reader.getString();
                    continue;
                }
                if ("commitTime".equals(fieldName)) {
                    deserializedActiveBaseSecurityAdminRule.commitTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedActiveBaseSecurityAdminRule.region = reader.getString();
                    continue;
                }
                if ("configurationDescription".equals(fieldName)) {
                    deserializedActiveBaseSecurityAdminRule.configurationDescription = reader.getString();
                    continue;
                }
                if ("ruleCollectionDescription".equals(fieldName)) {
                    deserializedActiveBaseSecurityAdminRule.ruleCollectionDescription = reader.getString();
                    continue;
                }
                if ("ruleCollectionAppliesToGroups".equals(fieldName)) {
                    List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups = reader.readArray(reader1 -> NetworkManagerSecurityGroupItem.fromJson(reader1));
                    deserializedActiveBaseSecurityAdminRule.ruleCollectionAppliesToGroups = ruleCollectionAppliesToGroups;
                    continue;
                }
                if ("ruleGroups".equals(fieldName)) {
                    List<ConfigurationGroup> ruleGroups = reader.readArray(reader1 -> ConfigurationGroup.fromJson(reader1));
                    deserializedActiveBaseSecurityAdminRule.ruleGroups = ruleGroups;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActiveBaseSecurityAdminRule;
        });
    }
}

