/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorHttpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorIcmpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorSuccessThreshold;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorTcpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorTestConfigurationProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PreferredIpVersion;
import java.io.IOException;

public final class ConnectionMonitorTestConfiguration
implements JsonSerializable<ConnectionMonitorTestConfiguration> {
    private String name;
    private Integer testFrequencySec;
    private ConnectionMonitorTestConfigurationProtocol protocol;
    private PreferredIpVersion preferredIpVersion;
    private ConnectionMonitorHttpConfiguration httpConfiguration;
    private ConnectionMonitorTcpConfiguration tcpConfiguration;
    private ConnectionMonitorIcmpConfiguration icmpConfiguration;
    private ConnectionMonitorSuccessThreshold successThreshold;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectionMonitorTestConfiguration.class);

    public String name() {
        return this.name;
    }

    public ConnectionMonitorTestConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public Integer testFrequencySec() {
        return this.testFrequencySec;
    }

    public ConnectionMonitorTestConfiguration withTestFrequencySec(Integer testFrequencySec) {
        this.testFrequencySec = testFrequencySec;
        return this;
    }

    public ConnectionMonitorTestConfigurationProtocol protocol() {
        return this.protocol;
    }

    public ConnectionMonitorTestConfiguration withProtocol(ConnectionMonitorTestConfigurationProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public PreferredIpVersion preferredIpVersion() {
        return this.preferredIpVersion;
    }

    public ConnectionMonitorTestConfiguration withPreferredIpVersion(PreferredIpVersion preferredIpVersion) {
        this.preferredIpVersion = preferredIpVersion;
        return this;
    }

    public ConnectionMonitorHttpConfiguration httpConfiguration() {
        return this.httpConfiguration;
    }

    public ConnectionMonitorTestConfiguration withHttpConfiguration(ConnectionMonitorHttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
        return this;
    }

    public ConnectionMonitorTcpConfiguration tcpConfiguration() {
        return this.tcpConfiguration;
    }

    public ConnectionMonitorTestConfiguration withTcpConfiguration(ConnectionMonitorTcpConfiguration tcpConfiguration) {
        this.tcpConfiguration = tcpConfiguration;
        return this;
    }

    public ConnectionMonitorIcmpConfiguration icmpConfiguration() {
        return this.icmpConfiguration;
    }

    public ConnectionMonitorTestConfiguration withIcmpConfiguration(ConnectionMonitorIcmpConfiguration icmpConfiguration) {
        this.icmpConfiguration = icmpConfiguration;
        return this;
    }

    public ConnectionMonitorSuccessThreshold successThreshold() {
        return this.successThreshold;
    }

    public ConnectionMonitorTestConfiguration withSuccessThreshold(ConnectionMonitorSuccessThreshold successThreshold) {
        this.successThreshold = successThreshold;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model ConnectionMonitorTestConfiguration"));
        }
        if (this.protocol() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property protocol in model ConnectionMonitorTestConfiguration"));
        }
        if (this.httpConfiguration() != null) {
            this.httpConfiguration().validate();
        }
        if (this.tcpConfiguration() != null) {
            this.tcpConfiguration().validate();
        }
        if (this.icmpConfiguration() != null) {
            this.icmpConfiguration().validate();
        }
        if (this.successThreshold() != null) {
            this.successThreshold().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeNumberField("testFrequencySec", this.testFrequencySec);
        jsonWriter.writeStringField("preferredIPVersion", this.preferredIpVersion == null ? null : this.preferredIpVersion.toString());
        jsonWriter.writeJsonField("httpConfiguration", this.httpConfiguration);
        jsonWriter.writeJsonField("tcpConfiguration", this.tcpConfiguration);
        jsonWriter.writeJsonField("icmpConfiguration", this.icmpConfiguration);
        jsonWriter.writeJsonField("successThreshold", this.successThreshold);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorTestConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorTestConfiguration deserializedConnectionMonitorTestConfiguration = new ConnectionMonitorTestConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.name = reader.getString();
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.protocol = ConnectionMonitorTestConfigurationProtocol.fromString(reader.getString());
                    continue;
                }
                if ("testFrequencySec".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.testFrequencySec = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("preferredIPVersion".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.preferredIpVersion = PreferredIpVersion.fromString(reader.getString());
                    continue;
                }
                if ("httpConfiguration".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.httpConfiguration = ConnectionMonitorHttpConfiguration.fromJson(reader);
                    continue;
                }
                if ("tcpConfiguration".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.tcpConfiguration = ConnectionMonitorTcpConfiguration.fromJson(reader);
                    continue;
                }
                if ("icmpConfiguration".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.icmpConfiguration = ConnectionMonitorIcmpConfiguration.fromJson(reader);
                    continue;
                }
                if ("successThreshold".equals(fieldName)) {
                    deserializedConnectionMonitorTestConfiguration.successThreshold = ConnectionMonitorSuccessThreshold.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorTestConfiguration;
        });
    }
}

