/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.FilterItems;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.OrderBy;
import java.io.IOException;
import java.util.List;

public final class IdpsQueryObject
implements JsonSerializable<IdpsQueryObject> {
    private List<FilterItems> filters;
    private String search;
    private OrderBy orderBy;
    private Integer resultsPerPage;
    private Integer skip;

    public List<FilterItems> filters() {
        return this.filters;
    }

    public IdpsQueryObject withFilters(List<FilterItems> filters) {
        this.filters = filters;
        return this;
    }

    public String search() {
        return this.search;
    }

    public IdpsQueryObject withSearch(String search) {
        this.search = search;
        return this;
    }

    public OrderBy orderBy() {
        return this.orderBy;
    }

    public IdpsQueryObject withOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public Integer resultsPerPage() {
        return this.resultsPerPage;
    }

    public IdpsQueryObject withResultsPerPage(Integer resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
        return this;
    }

    public Integer skip() {
        return this.skip;
    }

    public IdpsQueryObject withSkip(Integer skip) {
        this.skip = skip;
        return this;
    }

    public void validate() {
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
        if (this.orderBy() != null) {
            this.orderBy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("search", this.search);
        jsonWriter.writeJsonField("orderBy", this.orderBy);
        jsonWriter.writeNumberField("resultsPerPage", this.resultsPerPage);
        jsonWriter.writeNumberField("skip", this.skip);
        return jsonWriter.writeEndObject();
    }

    public static IdpsQueryObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IdpsQueryObject deserializedIdpsQueryObject = new IdpsQueryObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filters".equals(fieldName)) {
                    List<FilterItems> filters = reader.readArray(reader1 -> FilterItems.fromJson(reader1));
                    deserializedIdpsQueryObject.filters = filters;
                    continue;
                }
                if ("search".equals(fieldName)) {
                    deserializedIdpsQueryObject.search = reader.getString();
                    continue;
                }
                if ("orderBy".equals(fieldName)) {
                    deserializedIdpsQueryObject.orderBy = OrderBy.fromJson(reader);
                    continue;
                }
                if ("resultsPerPage".equals(fieldName)) {
                    deserializedIdpsQueryObject.resultsPerPage = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("skip".equals(fieldName)) {
                    deserializedIdpsQueryObject.skip = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdpsQueryObject;
        });
    }
}

