/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProtocolType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.QosIpRange;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.QosPortRange;
import java.io.IOException;
import java.util.List;

public final class QosDefinition
implements JsonSerializable<QosDefinition> {
    private List<Integer> markings;
    private List<QosIpRange> sourceIpRanges;
    private List<QosIpRange> destinationIpRanges;
    private List<QosPortRange> sourcePortRanges;
    private List<QosPortRange> destinationPortRanges;
    private ProtocolType protocol;

    public List<Integer> markings() {
        return this.markings;
    }

    public QosDefinition withMarkings(List<Integer> markings) {
        this.markings = markings;
        return this;
    }

    public List<QosIpRange> sourceIpRanges() {
        return this.sourceIpRanges;
    }

    public QosDefinition withSourceIpRanges(List<QosIpRange> sourceIpRanges) {
        this.sourceIpRanges = sourceIpRanges;
        return this;
    }

    public List<QosIpRange> destinationIpRanges() {
        return this.destinationIpRanges;
    }

    public QosDefinition withDestinationIpRanges(List<QosIpRange> destinationIpRanges) {
        this.destinationIpRanges = destinationIpRanges;
        return this;
    }

    public List<QosPortRange> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public QosDefinition withSourcePortRanges(List<QosPortRange> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<QosPortRange> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public QosDefinition withDestinationPortRanges(List<QosPortRange> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public ProtocolType protocol() {
        return this.protocol;
    }

    public QosDefinition withProtocol(ProtocolType protocol) {
        this.protocol = protocol;
        return this;
    }

    public void validate() {
        if (this.sourceIpRanges() != null) {
            this.sourceIpRanges().forEach(e -> e.validate());
        }
        if (this.destinationIpRanges() != null) {
            this.destinationIpRanges().forEach(e -> e.validate());
        }
        if (this.sourcePortRanges() != null) {
            this.sourcePortRanges().forEach(e -> e.validate());
        }
        if (this.destinationPortRanges() != null) {
            this.destinationPortRanges().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("markings", this.markings, (writer, element) -> writer.writeInt((int)element));
        jsonWriter.writeArrayField("sourceIpRanges", this.sourceIpRanges, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("destinationIpRanges", this.destinationIpRanges, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("sourcePortRanges", this.sourcePortRanges, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("destinationPortRanges", this.destinationPortRanges, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        return jsonWriter.writeEndObject();
    }

    public static QosDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QosDefinition deserializedQosDefinition = new QosDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("markings".equals(fieldName)) {
                    List<Integer> markings = reader.readArray(reader1 -> reader1.getInt());
                    deserializedQosDefinition.markings = markings;
                    continue;
                }
                if ("sourceIpRanges".equals(fieldName)) {
                    List<QosIpRange> sourceIpRanges = reader.readArray(reader1 -> QosIpRange.fromJson(reader1));
                    deserializedQosDefinition.sourceIpRanges = sourceIpRanges;
                    continue;
                }
                if ("destinationIpRanges".equals(fieldName)) {
                    List<QosIpRange> destinationIpRanges = reader.readArray(reader1 -> QosIpRange.fromJson(reader1));
                    deserializedQosDefinition.destinationIpRanges = destinationIpRanges;
                    continue;
                }
                if ("sourcePortRanges".equals(fieldName)) {
                    List<QosPortRange> sourcePortRanges = reader.readArray(reader1 -> QosPortRange.fromJson(reader1));
                    deserializedQosDefinition.sourcePortRanges = sourcePortRanges;
                    continue;
                }
                if ("destinationPortRanges".equals(fieldName)) {
                    List<QosPortRange> destinationPortRanges = reader.readArray(reader1 -> QosPortRange.fromJson(reader1));
                    deserializedQosDefinition.destinationPortRanges = destinationPortRanges;
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedQosDefinition.protocol = ProtocolType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQosDefinition;
        });
    }
}

