/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpTraffic;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ReachabilityAnalysisIntentProperties
implements JsonSerializable<ReachabilityAnalysisIntentProperties> {
    private ProvisioningState provisioningState;
    private String description;
    private String sourceResourceId;
    private String destinationResourceId;
    private IpTraffic ipTraffic;
    private static final ClientLogger LOGGER = new ClientLogger(ReachabilityAnalysisIntentProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ReachabilityAnalysisIntentProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ReachabilityAnalysisIntentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public ReachabilityAnalysisIntentProperties withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    public String destinationResourceId() {
        return this.destinationResourceId;
    }

    public ReachabilityAnalysisIntentProperties withDestinationResourceId(String destinationResourceId) {
        this.destinationResourceId = destinationResourceId;
        return this;
    }

    public IpTraffic ipTraffic() {
        return this.ipTraffic;
    }

    public ReachabilityAnalysisIntentProperties withIpTraffic(IpTraffic ipTraffic) {
        this.ipTraffic = ipTraffic;
        return this;
    }

    public void validate() {
        if (this.sourceResourceId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sourceResourceId in model ReachabilityAnalysisIntentProperties"));
        }
        if (this.destinationResourceId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property destinationResourceId in model ReachabilityAnalysisIntentProperties"));
        }
        if (this.ipTraffic() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property ipTraffic in model ReachabilityAnalysisIntentProperties"));
        }
        this.ipTraffic().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId);
        jsonWriter.writeStringField("destinationResourceId", this.destinationResourceId);
        jsonWriter.writeJsonField("ipTraffic", this.ipTraffic);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ReachabilityAnalysisIntentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReachabilityAnalysisIntentProperties deserializedReachabilityAnalysisIntentProperties = new ReachabilityAnalysisIntentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentProperties.sourceResourceId = reader.getString();
                    continue;
                }
                if ("destinationResourceId".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentProperties.destinationResourceId = reader.getString();
                    continue;
                }
                if ("ipTraffic".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentProperties.ipTraffic = IpTraffic.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReachabilityAnalysisIntentProperties;
        });
    }
}

