/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.RedisLinkedServerCreateProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ReplicationRole;
import java.io.IOException;

public final class RedisLinkedServerProperties
extends RedisLinkedServerCreateProperties {
    private String provisioningState;
    private String primaryHostname;
    private String geoReplicatedPrimaryHostname;
    private static final ClientLogger LOGGER = new ClientLogger(RedisLinkedServerProperties.class);

    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    public String primaryHostname() {
        return this.primaryHostname;
    }

    @Override
    public String geoReplicatedPrimaryHostname() {
        return this.geoReplicatedPrimaryHostname;
    }

    @Override
    public RedisLinkedServerProperties withLinkedRedisCacheId(String linkedRedisCacheId) {
        super.withLinkedRedisCacheId(linkedRedisCacheId);
        return this;
    }

    @Override
    public RedisLinkedServerProperties withLinkedRedisCacheLocation(String linkedRedisCacheLocation) {
        super.withLinkedRedisCacheLocation(linkedRedisCacheLocation);
        return this;
    }

    @Override
    public RedisLinkedServerProperties withServerRole(ReplicationRole serverRole) {
        super.withServerRole(serverRole);
        return this;
    }

    @Override
    public void validate() {
        if (this.linkedRedisCacheId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property linkedRedisCacheId in model RedisLinkedServerProperties"));
        }
        if (this.linkedRedisCacheLocation() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property linkedRedisCacheLocation in model RedisLinkedServerProperties"));
        }
        if (this.serverRole() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property serverRole in model RedisLinkedServerProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("linkedRedisCacheId", this.linkedRedisCacheId());
        jsonWriter.writeStringField("linkedRedisCacheLocation", this.linkedRedisCacheLocation());
        jsonWriter.writeStringField("serverRole", this.serverRole() == null ? null : this.serverRole().toString());
        return jsonWriter.writeEndObject();
    }

    public static RedisLinkedServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisLinkedServerProperties deserializedRedisLinkedServerProperties = new RedisLinkedServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedRedisCacheId".equals(fieldName)) {
                    deserializedRedisLinkedServerProperties.withLinkedRedisCacheId(reader.getString());
                    continue;
                }
                if ("linkedRedisCacheLocation".equals(fieldName)) {
                    deserializedRedisLinkedServerProperties.withLinkedRedisCacheLocation(reader.getString());
                    continue;
                }
                if ("serverRole".equals(fieldName)) {
                    deserializedRedisLinkedServerProperties.withServerRole(ReplicationRole.fromString(reader.getString()));
                    continue;
                }
                if ("geoReplicatedPrimaryHostName".equals(fieldName)) {
                    deserializedRedisLinkedServerProperties.geoReplicatedPrimaryHostname = reader.getString();
                    continue;
                }
                if ("primaryHostName".equals(fieldName)) {
                    deserializedRedisLinkedServerProperties.primaryHostname = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRedisLinkedServerProperties.provisioningState = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisLinkedServerProperties;
        });
    }
}

