/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisCommonProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.TlsVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.UpdateChannel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ZonalAllocationPolicy;
import java.io.IOException;
import java.util.Map;

public final class RedisUpdateProperties
extends RedisCommonProperties {
    private Sku sku;

    public Sku sku() {
        return this.sku;
    }

    public RedisUpdateProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    @Override
    public RedisUpdateProperties withRedisConfiguration(RedisConfiguration redisConfiguration) {
        super.withRedisConfiguration(redisConfiguration);
        return this;
    }

    @Override
    public RedisUpdateProperties withRedisVersion(String redisVersion) {
        super.withRedisVersion(redisVersion);
        return this;
    }

    @Override
    public RedisUpdateProperties withEnableNonSslPort(Boolean enableNonSslPort) {
        super.withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    @Override
    public RedisUpdateProperties withReplicasPerMaster(Integer replicasPerMaster) {
        super.withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    @Override
    public RedisUpdateProperties withReplicasPerPrimary(Integer replicasPerPrimary) {
        super.withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    @Override
    public RedisUpdateProperties withTenantSettings(Map<String, String> tenantSettings) {
        super.withTenantSettings(tenantSettings);
        return this;
    }

    @Override
    public RedisUpdateProperties withShardCount(Integer shardCount) {
        super.withShardCount(shardCount);
        return this;
    }

    @Override
    public RedisUpdateProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public RedisUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public RedisUpdateProperties withUpdateChannel(UpdateChannel updateChannel) {
        super.withUpdateChannel(updateChannel);
        return this;
    }

    @Override
    public RedisUpdateProperties withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        super.withDisableAccessKeyAuthentication(disableAccessKeyAuthentication);
        return this;
    }

    @Override
    public RedisUpdateProperties withZonalAllocationPolicy(ZonalAllocationPolicy zonalAllocationPolicy) {
        super.withZonalAllocationPolicy(zonalAllocationPolicy);
        return this;
    }

    @Override
    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.redisConfiguration() != null) {
            this.redisConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("redisConfiguration", this.redisConfiguration());
        jsonWriter.writeStringField("redisVersion", this.redisVersion());
        jsonWriter.writeBooleanField("enableNonSslPort", this.enableNonSslPort());
        jsonWriter.writeNumberField("replicasPerMaster", this.replicasPerMaster());
        jsonWriter.writeNumberField("replicasPerPrimary", this.replicasPerPrimary());
        jsonWriter.writeMapField("tenantSettings", this.tenantSettings(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeNumberField("shardCount", this.shardCount());
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion() == null ? null : this.minimumTlsVersion().toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess() == null ? null : this.publicNetworkAccess().toString());
        jsonWriter.writeStringField("updateChannel", this.updateChannel() == null ? null : this.updateChannel().toString());
        jsonWriter.writeBooleanField("disableAccessKeyAuthentication", this.disableAccessKeyAuthentication());
        jsonWriter.writeStringField("zonalAllocationPolicy", this.zonalAllocationPolicy() == null ? null : this.zonalAllocationPolicy().toString());
        jsonWriter.writeJsonField("sku", this.sku);
        return jsonWriter.writeEndObject();
    }

    public static RedisUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisUpdateProperties deserializedRedisUpdateProperties = new RedisUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("redisConfiguration".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withRedisConfiguration(RedisConfiguration.fromJson(reader));
                    continue;
                }
                if ("redisVersion".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withRedisVersion(reader.getString());
                    continue;
                }
                if ("enableNonSslPort".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withEnableNonSslPort(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("replicasPerMaster".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withReplicasPerMaster(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("replicasPerPrimary".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withReplicasPerPrimary(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("tenantSettings".equals(fieldName)) {
                    Map<String, String> tenantSettings = reader.readMap(reader1 -> reader1.getString());
                    deserializedRedisUpdateProperties.withTenantSettings((Map)tenantSettings);
                    continue;
                }
                if ("shardCount".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withShardCount(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withMinimumTlsVersion(TlsVersion.fromString(reader.getString()));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withPublicNetworkAccess(PublicNetworkAccess.fromString(reader.getString()));
                    continue;
                }
                if ("updateChannel".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withUpdateChannel(UpdateChannel.fromString(reader.getString()));
                    continue;
                }
                if ("disableAccessKeyAuthentication".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withDisableAccessKeyAuthentication(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("zonalAllocationPolicy".equals(fieldName)) {
                    deserializedRedisUpdateProperties.withZonalAllocationPolicy(ZonalAllocationPolicy.fromString(reader.getString()));
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedRedisUpdateProperties.sku = Sku.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisUpdateProperties;
        });
    }
}

