/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ImportRdbParameters
implements JsonSerializable<ImportRdbParameters> {
    private String format;
    private List<String> files;
    private String preferredDataArchiveAuthMethod;
    private String storageSubscriptionId;
    private static final ClientLogger LOGGER = new ClientLogger(ImportRdbParameters.class);

    public String format() {
        return this.format;
    }

    public ImportRdbParameters withFormat(String format) {
        this.format = format;
        return this;
    }

    public List<String> files() {
        return this.files;
    }

    public ImportRdbParameters withFiles(List<String> files) {
        this.files = files;
        return this;
    }

    public String preferredDataArchiveAuthMethod() {
        return this.preferredDataArchiveAuthMethod;
    }

    public ImportRdbParameters withPreferredDataArchiveAuthMethod(String preferredDataArchiveAuthMethod) {
        this.preferredDataArchiveAuthMethod = preferredDataArchiveAuthMethod;
        return this;
    }

    public String storageSubscriptionId() {
        return this.storageSubscriptionId;
    }

    public ImportRdbParameters withStorageSubscriptionId(String storageSubscriptionId) {
        this.storageSubscriptionId = storageSubscriptionId;
        return this;
    }

    public void validate() {
        if (this.files() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property files in model ImportRdbParameters"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("files", this.files, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("format", this.format);
        jsonWriter.writeStringField("preferred-data-archive-auth-method", this.preferredDataArchiveAuthMethod);
        jsonWriter.writeStringField("storage-subscription-id", this.storageSubscriptionId);
        return jsonWriter.writeEndObject();
    }

    public static ImportRdbParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImportRdbParameters deserializedImportRdbParameters = new ImportRdbParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("files".equals(fieldName)) {
                    List<String> files = reader.readArray(reader1 -> reader1.getString());
                    deserializedImportRdbParameters.files = files;
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedImportRdbParameters.format = reader.getString();
                    continue;
                }
                if ("preferred-data-archive-auth-method".equals(fieldName)) {
                    deserializedImportRdbParameters.preferredDataArchiveAuthMethod = reader.getString();
                    continue;
                }
                if ("storage-subscription-id".equals(fieldName)) {
                    deserializedImportRdbParameters.storageSubscriptionId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportRdbParameters;
        });
    }
}

