/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.RedisCreateProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ManagedServiceIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.TlsVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.UpdateChannel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ZonalAllocationPolicy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class RedisCreateParameters
implements JsonSerializable<RedisCreateParameters> {
    private RedisCreateProperties innerProperties = new RedisCreateProperties();
    private List<String> zones;
    private String location;
    private Map<String, String> tags;
    private ManagedServiceIdentity identity;
    private static final ClientLogger LOGGER = new ClientLogger(RedisCreateParameters.class);

    private RedisCreateProperties innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public RedisCreateParameters withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String location() {
        return this.location;
    }

    public RedisCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public RedisCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public RedisCreateParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Sku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public RedisCreateParameters withSku(Sku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public RedisCreateParameters withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    public RedisCreateParameters withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    public RedisConfiguration redisConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().redisConfiguration();
    }

    public RedisCreateParameters withRedisConfiguration(RedisConfiguration redisConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withRedisConfiguration(redisConfiguration);
        return this;
    }

    public String redisVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().redisVersion();
    }

    public RedisCreateParameters withRedisVersion(String redisVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withRedisVersion(redisVersion);
        return this;
    }

    public Boolean enableNonSslPort() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNonSslPort();
    }

    public RedisCreateParameters withEnableNonSslPort(Boolean enableNonSslPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    public Integer replicasPerMaster() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerMaster();
    }

    public RedisCreateParameters withReplicasPerMaster(Integer replicasPerMaster) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    public Integer replicasPerPrimary() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerPrimary();
    }

    public RedisCreateParameters withReplicasPerPrimary(Integer replicasPerPrimary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    public Map<String, String> tenantSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantSettings();
    }

    public RedisCreateParameters withTenantSettings(Map<String, String> tenantSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withTenantSettings((Map)tenantSettings);
        return this;
    }

    public Integer shardCount() {
        return this.innerProperties() == null ? null : this.innerProperties().shardCount();
    }

    public RedisCreateParameters withShardCount(Integer shardCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withShardCount(shardCount);
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    public RedisCreateParameters withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public RedisCreateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public UpdateChannel updateChannel() {
        return this.innerProperties() == null ? null : this.innerProperties().updateChannel();
    }

    public RedisCreateParameters withUpdateChannel(UpdateChannel updateChannel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withUpdateChannel(updateChannel);
        return this;
    }

    public Boolean disableAccessKeyAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().disableAccessKeyAuthentication();
    }

    public RedisCreateParameters withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withDisableAccessKeyAuthentication(disableAccessKeyAuthentication);
        return this;
    }

    public ZonalAllocationPolicy zonalAllocationPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().zonalAllocationPolicy();
    }

    public RedisCreateParameters withZonalAllocationPolicy(ZonalAllocationPolicy zonalAllocationPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisCreateProperties();
        }
        this.innerProperties().withZonalAllocationPolicy(zonalAllocationPolicy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property innerProperties in model RedisCreateParameters"));
        }
        this.innerProperties().validate();
        if (this.location() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property location in model RedisCreateParameters"));
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static RedisCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisCreateParameters deserializedRedisCreateParameters = new RedisCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedRedisCreateParameters.innerProperties = RedisCreateProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRedisCreateParameters.location = reader.getString();
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedRedisCreateParameters.zones = zones;
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRedisCreateParameters.tags = tags;
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedRedisCreateParameters.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisCreateParameters;
        });
    }
}

