/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.RedisUpdateProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ManagedServiceIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.TlsVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.UpdateChannel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ZonalAllocationPolicy;
import java.io.IOException;
import java.util.Map;

public final class RedisUpdateParameters
implements JsonSerializable<RedisUpdateParameters> {
    private RedisUpdateProperties innerProperties;
    private Map<String, String> tags;
    private ManagedServiceIdentity identity;

    private RedisUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public RedisUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public RedisUpdateParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Sku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public RedisUpdateParameters withSku(Sku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public RedisConfiguration redisConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().redisConfiguration();
    }

    public RedisUpdateParameters withRedisConfiguration(RedisConfiguration redisConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withRedisConfiguration(redisConfiguration);
        return this;
    }

    public String redisVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().redisVersion();
    }

    public RedisUpdateParameters withRedisVersion(String redisVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withRedisVersion(redisVersion);
        return this;
    }

    public Boolean enableNonSslPort() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNonSslPort();
    }

    public RedisUpdateParameters withEnableNonSslPort(Boolean enableNonSslPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    public Integer replicasPerMaster() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerMaster();
    }

    public RedisUpdateParameters withReplicasPerMaster(Integer replicasPerMaster) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    public Integer replicasPerPrimary() {
        return this.innerProperties() == null ? null : this.innerProperties().replicasPerPrimary();
    }

    public RedisUpdateParameters withReplicasPerPrimary(Integer replicasPerPrimary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    public Map<String, String> tenantSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantSettings();
    }

    public RedisUpdateParameters withTenantSettings(Map<String, String> tenantSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withTenantSettings((Map)tenantSettings);
        return this;
    }

    public Integer shardCount() {
        return this.innerProperties() == null ? null : this.innerProperties().shardCount();
    }

    public RedisUpdateParameters withShardCount(Integer shardCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withShardCount(shardCount);
        return this;
    }

    public TlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    public RedisUpdateParameters withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public RedisUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public UpdateChannel updateChannel() {
        return this.innerProperties() == null ? null : this.innerProperties().updateChannel();
    }

    public RedisUpdateParameters withUpdateChannel(UpdateChannel updateChannel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withUpdateChannel(updateChannel);
        return this;
    }

    public Boolean disableAccessKeyAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().disableAccessKeyAuthentication();
    }

    public RedisUpdateParameters withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withDisableAccessKeyAuthentication(disableAccessKeyAuthentication);
        return this;
    }

    public ZonalAllocationPolicy zonalAllocationPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().zonalAllocationPolicy();
    }

    public RedisUpdateParameters withZonalAllocationPolicy(ZonalAllocationPolicy zonalAllocationPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RedisUpdateProperties();
        }
        this.innerProperties().withZonalAllocationPolicy(zonalAllocationPolicy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static RedisUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisUpdateParameters deserializedRedisUpdateParameters = new RedisUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedRedisUpdateParameters.innerProperties = RedisUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRedisUpdateParameters.tags = tags;
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedRedisUpdateParameters.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisUpdateParameters;
        });
    }
}

