/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.SkuFamily;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.SkuName;
import java.io.IOException;

public final class Sku
implements JsonSerializable<Sku> {
    private SkuName name;
    private SkuFamily family;
    private int capacity;
    private static final ClientLogger LOGGER = new ClientLogger(Sku.class);

    public SkuName name() {
        return this.name;
    }

    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuFamily family() {
        return this.family;
    }

    public Sku withFamily(SkuFamily family) {
        this.family = family;
        return this;
    }

    public int capacity() {
        return this.capacity;
    }

    public Sku withCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model Sku"));
        }
        if (this.family() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property family in model Sku"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("family", this.family == null ? null : this.family.toString());
        jsonWriter.writeIntField("capacity", this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static Sku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Sku deserializedSku = new Sku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSku.name = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedSku.family = SkuFamily.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedSku.capacity = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSku;
        });
    }
}

