/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ExtendedLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Identity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Plan;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Sku;
import java.io.IOException;
import java.util.Map;

public class GenericResourceInner
extends Resource {
    private Plan plan;
    private Object properties;
    private String kind;
    private String managedBy;
    private Sku sku;
    private Identity identity;
    private ExtendedLocation extendedLocation;
    private String type;
    private String name;
    private String id;

    public Plan plan() {
        return this.plan;
    }

    public GenericResourceInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public Object properties() {
        return this.properties;
    }

    public GenericResourceInner withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public GenericResourceInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String managedBy() {
        return this.managedBy;
    }

    public GenericResourceInner withManagedBy(String managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public GenericResourceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public GenericResourceInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public GenericResourceInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public GenericResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public GenericResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("plan", this.plan);
        if (this.properties != null) {
            jsonWriter.writeUntypedField("properties", this.properties);
        }
        jsonWriter.writeStringField("kind", this.kind);
        jsonWriter.writeStringField("managedBy", this.managedBy);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("extendedLocation", this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static GenericResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GenericResourceInner deserializedGenericResourceInner = new GenericResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGenericResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGenericResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGenericResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedGenericResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGenericResourceInner.withTags((Map)tags);
                    continue;
                }
                if ("plan".equals(fieldName)) {
                    deserializedGenericResourceInner.plan = Plan.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGenericResourceInner.properties = reader.readUntyped();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedGenericResourceInner.kind = reader.getString();
                    continue;
                }
                if ("managedBy".equals(fieldName)) {
                    deserializedGenericResourceInner.managedBy = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedGenericResourceInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedGenericResourceInner.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedGenericResourceInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGenericResourceInner;
        });
    }
}

