/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.exception.AggregatedManagementException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collection;
import java.util.function.BiFunction;

public class BatchDeletionImpl {
    public static Flux<String> deleteByIdsAsync(Collection<String> ids, BiFunction<String, String, Mono<Void>> deleteByGroupAndNameAsync) {
        if (ids == null || ids.isEmpty()) {
            return Flux.empty();
        }
        return Flux.fromIterable(ids).flatMapDelayError(id -> {
            String resourceGroupName = ResourceUtils.groupFromResourceId(id);
            String name = ResourceUtils.nameFromResourceId(id);
            return ((Mono)deleteByGroupAndNameAsync.apply(resourceGroupName, name)).then(Mono.just(id));
        }, 32, 32).onErrorMap(AggregatedManagementException::convertToManagementException).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler());
    }
}

