/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class DAGNode<DataT, NodeT extends DAGNode<DataT, NodeT>>
extends Node<DataT, NodeT> {
    private final List<String> dependentKeys;
    private int toBeResolved;
    private boolean isPreparer;
    private final ReentrantLock lock;
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private static final String ERROR_MESSAGE_FORMAT = "invalid state - %s: The dependency '%s' is already reported or there is no such dependencyKey";

    public DAGNode(String key, DataT data) {
        super(key, data);
        this.dependentKeys = new ArrayList<String>();
        this.lock = new ReentrantLock();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    List<String> dependentKeys() {
        return Collections.unmodifiableList(this.dependentKeys);
    }

    public void addDependent(String key) {
        this.dependentKeys.add(key);
    }

    public List<String> dependencyKeys() {
        return this.children();
    }

    public void addDependency(String dependencyKey) {
        super.addChild(dependencyKey);
    }

    public void removeDependency(String dependencyKey) {
        super.removeChild(dependencyKey);
    }

    public boolean hasDependencies() {
        return this.hasChildren();
    }

    public void setPreparer(boolean isPreparer) {
        this.isPreparer = isPreparer;
    }

    public boolean isPreparer() {
        return this.isPreparer;
    }

    public void initialize() {
        this.toBeResolved = this.dependencyKeys().size();
        this.dependentKeys.clear();
    }

    boolean hasAllResolved() {
        return this.toBeResolved == 0;
    }

    protected void onSuccessfulResolution(String dependencyKey) {
        if (this.toBeResolved == 0) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format(ERROR_MESSAGE_FORMAT, this.key(), dependencyKey)));
        }
        --this.toBeResolved;
    }

    protected void onFaultedResolution(String dependencyKey, Throwable throwable) {
        if (this.toBeResolved == 0) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format(ERROR_MESSAGE_FORMAT, this.key(), dependencyKey)));
        }
        --this.toBeResolved;
    }
}

