/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.FeatureClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.FeaturesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.SubscriptionFeatureRegistrationsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.OperationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.FeatureClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.FeaturesClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.SubscriptionFeatureRegistrationsClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.OperationListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;

@ServiceClient(builder=FeatureClientBuilder.class)
public final class FeatureClientImpl
extends AzureServiceClient
implements FeatureClient {
    private final FeatureClientService service;
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final FeaturesClient features;
    private final SubscriptionFeatureRegistrationsClient subscriptionFeatureRegistrations;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public FeaturesClient getFeatures() {
        return this.features;
    }

    @Override
    public SubscriptionFeatureRegistrationsClient getSubscriptionFeatureRegistrations() {
        return this.subscriptionFeatureRegistrations;
    }

    FeatureClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2021-07-01";
        this.features = new FeaturesClientImpl(this);
        this.subscriptionFeatureRegistrations = new SubscriptionFeatureRegistrationsClientImpl(this);
        this.service = RestProxy.create(FeatureClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OperationInner>> listOperationsSinglePageAsync() {
        if (this.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.listOperations(this.getEndpoint(), this.getApiVersion(), "application/json, text/json", (Context)context)).map(res -> new PagedResponseBase<Object, OperationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationListResult)res.getValue()).value(), ((OperationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OperationInner>> listOperationsSinglePageAsync(Context context) {
        if (this.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json, text/json";
        context = this.mergeContext(context);
        return this.service.listOperations(this.getEndpoint(), this.getApiVersion(), "application/json, text/json", context).map(res -> new PagedResponseBase<Object, OperationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationListResult)res.getValue()).value(), ((OperationListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OperationInner> listOperationsAsync() {
        return new PagedFlux<OperationInner>(() -> this.listOperationsSinglePageAsync(), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<OperationInner> listOperationsAsync(Context context) {
        return new PagedFlux<OperationInner>(() -> this.listOperationsSinglePageAsync(context), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationInner> listOperations() {
        return new PagedIterable<OperationInner>(this.listOperationsAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationInner> listOperations(Context context) {
        return new PagedIterable<OperationInner>(this.listOperationsAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OperationInner>> listOperationsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.listOperationsNext(nextLink, this.getEndpoint(), "application/json, text/json", (Context)context)).map(res -> new PagedResponseBase<Object, OperationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationListResult)res.getValue()).value(), ((OperationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OperationInner>> listOperationsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json, text/json";
        context = this.mergeContext(context);
        return this.service.listOperationsNext(nextLink, this.getEndpoint(), "application/json, text/json", context).map(res -> new PagedResponseBase<Object, OperationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationListResult)res.getValue()).value(), ((OperationListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FeatureClient")
    public static interface FeatureClientService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Features/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OperationListResult>> listOperations(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OperationListResult>> listOperationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

