/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.PolicyDefinitionVersionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.PolicyDefinitionVersionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.PolicyDefinitionVersionListResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.PolicyClientImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class PolicyDefinitionVersionsClientImpl
implements InnerSupportsDelete<Void>,
PolicyDefinitionVersionsClient {
    private final PolicyDefinitionVersionsService service;
    private final PolicyClientImpl client;

    PolicyDefinitionVersionsClientImpl(PolicyClientImpl client) {
        this.service = RestProxy.create(PolicyDefinitionVersionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionVersionListResultInner>> listAllBuiltinsWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllBuiltins(this.client.getEndpoint(), "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionVersionListResultInner>> listAllBuiltinsWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAllBuiltins(this.client.getEndpoint(), "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionVersionListResultInner> listAllBuiltinsAsync() {
        return this.listAllBuiltinsWithResponseAsync().flatMap(res -> Mono.justOrEmpty((PolicyDefinitionVersionListResultInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionVersionListResultInner> listAllBuiltinsWithResponse(Context context) {
        return this.listAllBuiltinsWithResponseAsync(context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionVersionListResultInner listAllBuiltins() {
        return this.listAllBuiltinsWithResponse(Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionVersionListResultInner>> listAllAtManagementGroupWithResponseAsync(String managementGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllAtManagementGroup(this.client.getEndpoint(), managementGroupName, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionVersionListResultInner>> listAllAtManagementGroupWithResponseAsync(String managementGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAllAtManagementGroup(this.client.getEndpoint(), managementGroupName, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionVersionListResultInner> listAllAtManagementGroupAsync(String managementGroupName) {
        return this.listAllAtManagementGroupWithResponseAsync(managementGroupName).flatMap(res -> Mono.justOrEmpty((PolicyDefinitionVersionListResultInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionVersionListResultInner> listAllAtManagementGroupWithResponse(String managementGroupName, Context context) {
        return this.listAllAtManagementGroupWithResponseAsync(managementGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionVersionListResultInner listAllAtManagementGroup(String managementGroupName) {
        return this.listAllAtManagementGroupWithResponse(managementGroupName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionVersionListResultInner>> listAllWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAll(this.client.getEndpoint(), this.client.getSubscriptionId(), "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionVersionListResultInner>> listAllWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAll(this.client.getEndpoint(), this.client.getSubscriptionId(), "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionVersionListResultInner> listAllAsync() {
        return this.listAllWithResponseAsync().flatMap(res -> Mono.justOrEmpty((PolicyDefinitionVersionListResultInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionVersionListResultInner> listAllWithResponse(Context context) {
        return this.listAllWithResponseAsync(context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionVersionListResultInner listAll() {
        return this.listAllWithResponse(Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionVersionInner>> createOrUpdateWithResponseAsync(String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), policyDefinitionName, policyDefinitionVersion, "2023-04-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionVersionInner>> createOrUpdateWithResponseAsync(String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), policyDefinitionName, policyDefinitionVersion, "2023-04-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionVersionInner> createOrUpdateAsync(String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters) {
        return this.createOrUpdateWithResponseAsync(policyDefinitionName, policyDefinitionVersion, parameters).flatMap(res -> Mono.justOrEmpty((PolicyDefinitionVersionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionVersionInner> createOrUpdateWithResponse(String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters, Context context) {
        return this.createOrUpdateWithResponseAsync(policyDefinitionName, policyDefinitionVersion, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionVersionInner createOrUpdate(String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters) {
        return this.createOrUpdateWithResponse(policyDefinitionName, policyDefinitionVersion, parameters, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String policyDefinitionName, String policyDefinitionVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), policyDefinitionName, policyDefinitionVersion, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String policyDefinitionName, String policyDefinitionVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), policyDefinitionName, policyDefinitionVersion, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String policyDefinitionName, String policyDefinitionVersion) {
        return this.deleteWithResponseAsync(policyDefinitionName, policyDefinitionVersion).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String policyDefinitionName, String policyDefinitionVersion, Context context) {
        return this.deleteWithResponseAsync(policyDefinitionName, policyDefinitionVersion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String policyDefinitionName, String policyDefinitionVersion) {
        this.deleteWithResponse(policyDefinitionName, policyDefinitionVersion, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionVersionInner>> getWithResponseAsync(String policyDefinitionName, String policyDefinitionVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), policyDefinitionName, policyDefinitionVersion, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionVersionInner>> getWithResponseAsync(String policyDefinitionName, String policyDefinitionVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), policyDefinitionName, policyDefinitionVersion, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionVersionInner> getAsync(String policyDefinitionName, String policyDefinitionVersion) {
        return this.getWithResponseAsync(policyDefinitionName, policyDefinitionVersion).flatMap(res -> Mono.justOrEmpty((PolicyDefinitionVersionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionVersionInner> getWithResponse(String policyDefinitionName, String policyDefinitionVersion, Context context) {
        return this.getWithResponseAsync(policyDefinitionName, policyDefinitionVersion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionVersionInner get(String policyDefinitionName, String policyDefinitionVersion) {
        return this.getWithResponse(policyDefinitionName, policyDefinitionVersion, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionVersionInner>> getBuiltInWithResponseAsync(String policyDefinitionName, String policyDefinitionVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBuiltIn(this.client.getEndpoint(), policyDefinitionName, policyDefinitionVersion, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionVersionInner>> getBuiltInWithResponseAsync(String policyDefinitionName, String policyDefinitionVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBuiltIn(this.client.getEndpoint(), policyDefinitionName, policyDefinitionVersion, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionVersionInner> getBuiltInAsync(String policyDefinitionName, String policyDefinitionVersion) {
        return this.getBuiltInWithResponseAsync(policyDefinitionName, policyDefinitionVersion).flatMap(res -> Mono.justOrEmpty((PolicyDefinitionVersionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionVersionInner> getBuiltInWithResponse(String policyDefinitionName, String policyDefinitionVersion, Context context) {
        return this.getBuiltInWithResponseAsync(policyDefinitionName, policyDefinitionVersion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionVersionInner getBuiltIn(String policyDefinitionName, String policyDefinitionVersion) {
        return this.getBuiltInWithResponse(policyDefinitionName, policyDefinitionVersion, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionVersionInner>> createOrUpdateAtManagementGroupWithResponseAsync(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), managementGroupName, policyDefinitionName, policyDefinitionVersion, "2023-04-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionVersionInner>> createOrUpdateAtManagementGroupWithResponseAsync(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), managementGroupName, policyDefinitionName, policyDefinitionVersion, "2023-04-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionVersionInner> createOrUpdateAtManagementGroupAsync(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters) {
        return this.createOrUpdateAtManagementGroupWithResponseAsync(managementGroupName, policyDefinitionName, policyDefinitionVersion, parameters).flatMap(res -> Mono.justOrEmpty((PolicyDefinitionVersionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionVersionInner> createOrUpdateAtManagementGroupWithResponse(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters, Context context) {
        return this.createOrUpdateAtManagementGroupWithResponseAsync(managementGroupName, policyDefinitionName, policyDefinitionVersion, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionVersionInner createOrUpdateAtManagementGroup(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters) {
        return this.createOrUpdateAtManagementGroupWithResponse(managementGroupName, policyDefinitionName, policyDefinitionVersion, parameters, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtManagementGroup(this.client.getEndpoint(), managementGroupName, policyDefinitionName, policyDefinitionVersion, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtManagementGroup(this.client.getEndpoint(), managementGroupName, policyDefinitionName, policyDefinitionVersion, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAtManagementGroupAsync(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion) {
        return this.deleteAtManagementGroupWithResponseAsync(managementGroupName, policyDefinitionName, policyDefinitionVersion).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAtManagementGroupWithResponse(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion, Context context) {
        return this.deleteAtManagementGroupWithResponseAsync(managementGroupName, policyDefinitionName, policyDefinitionVersion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtManagementGroup(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion) {
        this.deleteAtManagementGroupWithResponse(managementGroupName, policyDefinitionName, policyDefinitionVersion, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionVersionInner>> getAtManagementGroupWithResponseAsync(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtManagementGroup(this.client.getEndpoint(), managementGroupName, policyDefinitionName, policyDefinitionVersion, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionVersionInner>> getAtManagementGroupWithResponseAsync(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtManagementGroup(this.client.getEndpoint(), managementGroupName, policyDefinitionName, policyDefinitionVersion, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionVersionInner> getAtManagementGroupAsync(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion) {
        return this.getAtManagementGroupWithResponseAsync(managementGroupName, policyDefinitionName, policyDefinitionVersion).flatMap(res -> Mono.justOrEmpty((PolicyDefinitionVersionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionVersionInner> getAtManagementGroupWithResponse(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion, Context context) {
        return this.getAtManagementGroupWithResponseAsync(managementGroupName, policyDefinitionName, policyDefinitionVersion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionVersionInner getAtManagementGroup(String managementGroupName, String policyDefinitionName, String policyDefinitionVersion) {
        return this.getAtManagementGroupWithResponse(managementGroupName, policyDefinitionName, policyDefinitionVersion, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listSinglePageAsync(String policyDefinitionName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), policyDefinitionName, "2023-04-01", top, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listSinglePageAsync(String policyDefinitionName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), policyDefinitionName, "2023-04-01", top, "application/json", context).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionVersionInner> listAsync(String policyDefinitionName, Integer top) {
        return new PagedFlux<PolicyDefinitionVersionInner>(() -> this.listSinglePageAsync(policyDefinitionName, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionVersionInner> listAsync(String policyDefinitionName) {
        Integer top = null;
        return new PagedFlux<PolicyDefinitionVersionInner>(() -> this.listSinglePageAsync(policyDefinitionName, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyDefinitionVersionInner> listAsync(String policyDefinitionName, Integer top, Context context) {
        return new PagedFlux<PolicyDefinitionVersionInner>(() -> this.listSinglePageAsync(policyDefinitionName, top, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionVersionInner> list(String policyDefinitionName) {
        Integer top = null;
        return new PagedIterable<PolicyDefinitionVersionInner>(this.listAsync(policyDefinitionName, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionVersionInner> list(String policyDefinitionName, Integer top, Context context) {
        return new PagedIterable<PolicyDefinitionVersionInner>(this.listAsync(policyDefinitionName, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listBuiltInSinglePageAsync(String policyDefinitionName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuiltIn(this.client.getEndpoint(), policyDefinitionName, "2023-04-01", top, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listBuiltInSinglePageAsync(String policyDefinitionName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuiltIn(this.client.getEndpoint(), policyDefinitionName, "2023-04-01", top, "application/json", context).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionVersionInner> listBuiltInAsync(String policyDefinitionName, Integer top) {
        return new PagedFlux<PolicyDefinitionVersionInner>(() -> this.listBuiltInSinglePageAsync(policyDefinitionName, top), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionVersionInner> listBuiltInAsync(String policyDefinitionName) {
        Integer top = null;
        return new PagedFlux<PolicyDefinitionVersionInner>(() -> this.listBuiltInSinglePageAsync(policyDefinitionName, top), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyDefinitionVersionInner> listBuiltInAsync(String policyDefinitionName, Integer top, Context context) {
        return new PagedFlux<PolicyDefinitionVersionInner>(() -> this.listBuiltInSinglePageAsync(policyDefinitionName, top, context), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionVersionInner> listBuiltIn(String policyDefinitionName) {
        Integer top = null;
        return new PagedIterable<PolicyDefinitionVersionInner>(this.listBuiltInAsync(policyDefinitionName, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionVersionInner> listBuiltIn(String policyDefinitionName, Integer top, Context context) {
        return new PagedIterable<PolicyDefinitionVersionInner>(this.listBuiltInAsync(policyDefinitionName, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listByManagementGroupSinglePageAsync(String managementGroupName, String policyDefinitionName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByManagementGroup(this.client.getEndpoint(), managementGroupName, policyDefinitionName, "2023-04-01", top, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listByManagementGroupSinglePageAsync(String managementGroupName, String policyDefinitionName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByManagementGroup(this.client.getEndpoint(), managementGroupName, policyDefinitionName, "2023-04-01", top, "application/json", context).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionVersionInner> listByManagementGroupAsync(String managementGroupName, String policyDefinitionName, Integer top) {
        return new PagedFlux<PolicyDefinitionVersionInner>(() -> this.listByManagementGroupSinglePageAsync(managementGroupName, policyDefinitionName, top), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionVersionInner> listByManagementGroupAsync(String managementGroupName, String policyDefinitionName) {
        Integer top = null;
        return new PagedFlux<PolicyDefinitionVersionInner>(() -> this.listByManagementGroupSinglePageAsync(managementGroupName, policyDefinitionName, top), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyDefinitionVersionInner> listByManagementGroupAsync(String managementGroupName, String policyDefinitionName, Integer top, Context context) {
        return new PagedFlux<PolicyDefinitionVersionInner>(() -> this.listByManagementGroupSinglePageAsync(managementGroupName, policyDefinitionName, top, context), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionVersionInner> listByManagementGroup(String managementGroupName, String policyDefinitionName) {
        Integer top = null;
        return new PagedIterable<PolicyDefinitionVersionInner>(this.listByManagementGroupAsync(managementGroupName, policyDefinitionName, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionVersionInner> listByManagementGroup(String managementGroupName, String policyDefinitionName, Integer top, Context context) {
        return new PagedIterable<PolicyDefinitionVersionInner>(this.listByManagementGroupAsync(managementGroupName, policyDefinitionName, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listBuiltInNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuiltInNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listBuiltInNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuiltInNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listByManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionVersionInner>> listByManagementGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, PolicyDefinitionVersionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionVersionListResultInner)res.getValue()).value(), ((PolicyDefinitionVersionListResultInner)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyClientPolicyDe")
    public static interface PolicyDefinitionVersionsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Authorization/listPolicyDefinitionVersions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionListResultInner>> listAllBuiltins(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/listPolicyDefinitionVersions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionListResultInner>> listAllAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/listPolicyDefinitionVersions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionListResultInner>> listAll(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="policyDefinitionName") String var3, @PathParam(value="policyDefinitionVersion") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") PolicyDefinitionVersionInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="policyDefinitionName") String var3, @PathParam(value="policyDefinitionVersion") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="policyDefinitionName") String var3, @PathParam(value="policyDefinitionVersion") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionInner>> getBuiltIn(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @PathParam(value="policyDefinitionVersion") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionInner>> createOrUpdateAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupName") String var2, @PathParam(value="policyDefinitionName") String var3, @PathParam(value="policyDefinitionVersion") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") PolicyDefinitionVersionInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupName") String var2, @PathParam(value="policyDefinitionName") String var3, @PathParam(value="policyDefinitionVersion") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionInner>> getAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupName") String var2, @PathParam(value="policyDefinitionName") String var3, @PathParam(value="policyDefinitionVersion") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionListResultInner>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="policyDefinitionName") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionListResultInner>> listBuiltIn(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$top") Integer var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionListResultInner>> listByManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupName") String var2, @PathParam(value="policyDefinitionName") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionListResultInner>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionListResultInner>> listBuiltInNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionVersionListResultInner>> listByManagementGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

