/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.DebugSetting;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.DeploymentMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.DeploymentParameter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ExpressionEvaluationOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.OnErrorDeployment;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ParametersLink;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.TemplateLink;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ValidationLevel;
import java.io.IOException;
import java.util.Map;

public class DeploymentProperties
implements JsonSerializable<DeploymentProperties> {
    private Object template;
    private TemplateLink templateLink;
    private Map<String, DeploymentParameter> parameters;
    private ParametersLink parametersLink;
    private DeploymentMode mode;
    private DebugSetting debugSetting;
    private OnErrorDeployment onErrorDeployment;
    private ExpressionEvaluationOptions expressionEvaluationOptions;
    private ValidationLevel validationLevel;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentProperties.class);

    public Object template() {
        return this.template;
    }

    public DeploymentProperties withTemplate(Object template) {
        this.template = template;
        return this;
    }

    public TemplateLink templateLink() {
        return this.templateLink;
    }

    public DeploymentProperties withTemplateLink(TemplateLink templateLink) {
        this.templateLink = templateLink;
        return this;
    }

    public Map<String, DeploymentParameter> parameters() {
        return this.parameters;
    }

    public DeploymentProperties withParameters(Map<String, DeploymentParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ParametersLink parametersLink() {
        return this.parametersLink;
    }

    public DeploymentProperties withParametersLink(ParametersLink parametersLink) {
        this.parametersLink = parametersLink;
        return this;
    }

    public DeploymentMode mode() {
        return this.mode;
    }

    public DeploymentProperties withMode(DeploymentMode mode) {
        this.mode = mode;
        return this;
    }

    public DebugSetting debugSetting() {
        return this.debugSetting;
    }

    public DeploymentProperties withDebugSetting(DebugSetting debugSetting) {
        this.debugSetting = debugSetting;
        return this;
    }

    public OnErrorDeployment onErrorDeployment() {
        return this.onErrorDeployment;
    }

    public DeploymentProperties withOnErrorDeployment(OnErrorDeployment onErrorDeployment) {
        this.onErrorDeployment = onErrorDeployment;
        return this;
    }

    public ExpressionEvaluationOptions expressionEvaluationOptions() {
        return this.expressionEvaluationOptions;
    }

    public DeploymentProperties withExpressionEvaluationOptions(ExpressionEvaluationOptions expressionEvaluationOptions) {
        this.expressionEvaluationOptions = expressionEvaluationOptions;
        return this;
    }

    public ValidationLevel validationLevel() {
        return this.validationLevel;
    }

    public DeploymentProperties withValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    public void validate() {
        if (this.templateLink() != null) {
            this.templateLink().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.parametersLink() != null) {
            this.parametersLink().validate();
        }
        if (this.mode() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property mode in model DeploymentProperties"));
        }
        if (this.debugSetting() != null) {
            this.debugSetting().validate();
        }
        if (this.onErrorDeployment() != null) {
            this.onErrorDeployment().validate();
        }
        if (this.expressionEvaluationOptions() != null) {
            this.expressionEvaluationOptions().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeUntypedField("template", this.template);
        jsonWriter.writeJsonField("templateLink", this.templateLink);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("parametersLink", this.parametersLink);
        jsonWriter.writeJsonField("debugSetting", this.debugSetting);
        jsonWriter.writeJsonField("onErrorDeployment", this.onErrorDeployment);
        jsonWriter.writeJsonField("expressionEvaluationOptions", this.expressionEvaluationOptions);
        jsonWriter.writeStringField("validationLevel", this.validationLevel == null ? null : this.validationLevel.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeploymentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentProperties deserializedDeploymentProperties = new DeploymentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    deserializedDeploymentProperties.mode = DeploymentMode.fromString(reader.getString());
                    continue;
                }
                if ("template".equals(fieldName)) {
                    deserializedDeploymentProperties.template = reader.readUntyped();
                    continue;
                }
                if ("templateLink".equals(fieldName)) {
                    deserializedDeploymentProperties.templateLink = TemplateLink.fromJson(reader);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map<String, DeploymentParameter> parameters = reader.readMap(reader1 -> DeploymentParameter.fromJson(reader1));
                    deserializedDeploymentProperties.parameters = parameters;
                    continue;
                }
                if ("parametersLink".equals(fieldName)) {
                    deserializedDeploymentProperties.parametersLink = ParametersLink.fromJson(reader);
                    continue;
                }
                if ("debugSetting".equals(fieldName)) {
                    deserializedDeploymentProperties.debugSetting = DebugSetting.fromJson(reader);
                    continue;
                }
                if ("onErrorDeployment".equals(fieldName)) {
                    deserializedDeploymentProperties.onErrorDeployment = OnErrorDeployment.fromJson(reader);
                    continue;
                }
                if ("expressionEvaluationOptions".equals(fieldName)) {
                    deserializedDeploymentProperties.expressionEvaluationOptions = ExpressionEvaluationOptions.fromJson(reader);
                    continue;
                }
                if ("validationLevel".equals(fieldName)) {
                    deserializedDeploymentProperties.validationLevel = ValidationLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentProperties;
        });
    }
}

