/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Permission;
import java.io.IOException;
import java.util.List;

public final class RoleDefinition
implements JsonSerializable<RoleDefinition> {
    private String id;
    private String name;
    private Boolean isServiceRole;
    private List<Permission> permissions;
    private List<String> scopes;

    public String id() {
        return this.id;
    }

    public RoleDefinition withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public RoleDefinition withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isServiceRole() {
        return this.isServiceRole;
    }

    public RoleDefinition withIsServiceRole(Boolean isServiceRole) {
        this.isServiceRole = isServiceRole;
        return this;
    }

    public List<Permission> permissions() {
        return this.permissions;
    }

    public RoleDefinition withPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public RoleDefinition withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public void validate() {
        if (this.permissions() != null) {
            this.permissions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isServiceRole", this.isServiceRole);
        jsonWriter.writeArrayField("permissions", this.permissions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static RoleDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleDefinition deserializedRoleDefinition = new RoleDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRoleDefinition.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRoleDefinition.name = reader.getString();
                    continue;
                }
                if ("isServiceRole".equals(fieldName)) {
                    deserializedRoleDefinition.isServiceRole = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    List<Permission> permissions = reader.readArray(reader1 -> Permission.fromJson(reader1));
                    deserializedRoleDefinition.permissions = permissions;
                    continue;
                }
                if ("scopes".equals(fieldName)) {
                    List<String> scopes = reader.readArray(reader1 -> reader1.getString());
                    deserializedRoleDefinition.scopes = scopes;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleDefinition;
        });
    }
}

