/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.SearchServiceProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.DataPlaneAuthOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.EncryptionWithCmk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.HostingMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.Identity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.NetworkRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.SearchSemanticSearch;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.SearchServiceStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.Sku;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SearchServiceInner
extends Resource {
    private SearchServiceProperties innerProperties;
    private Sku sku;
    private Identity identity;
    private String id;
    private String name;
    private String type;

    private SearchServiceProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public SearchServiceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public SearchServiceInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public SearchServiceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SearchServiceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Integer replicaCount() {
        return this.innerProperties() == null ? null : this.innerProperties().replicaCount();
    }

    public SearchServiceInner withReplicaCount(Integer replicaCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withReplicaCount(replicaCount);
        return this;
    }

    public Integer partitionCount() {
        return this.innerProperties() == null ? null : this.innerProperties().partitionCount();
    }

    public SearchServiceInner withPartitionCount(Integer partitionCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withPartitionCount(partitionCount);
        return this;
    }

    public HostingMode hostingMode() {
        return this.innerProperties() == null ? null : this.innerProperties().hostingMode();
    }

    public SearchServiceInner withHostingMode(HostingMode hostingMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withHostingMode(hostingMode);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public SearchServiceInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public SearchServiceStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public String statusDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().statusDetails();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    public SearchServiceInner withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    public EncryptionWithCmk encryptionWithCmk() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionWithCmk();
    }

    public SearchServiceInner withEncryptionWithCmk(EncryptionWithCmk encryptionWithCmk) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withEncryptionWithCmk(encryptionWithCmk);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public SearchServiceInner withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public DataPlaneAuthOptions authOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().authOptions();
    }

    public SearchServiceInner withAuthOptions(DataPlaneAuthOptions authOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withAuthOptions(authOptions);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public SearchSemanticSearch semanticSearch() {
        return this.innerProperties() == null ? null : this.innerProperties().semanticSearch();
    }

    public SearchServiceInner withSemanticSearch(SearchSemanticSearch semanticSearch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SearchServiceProperties();
        }
        this.innerProperties().withSemanticSearch(semanticSearch);
        return this;
    }

    public List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedPrivateLinkResources();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static SearchServiceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchServiceInner deserializedSearchServiceInner = new SearchServiceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSearchServiceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSearchServiceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSearchServiceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSearchServiceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSearchServiceInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSearchServiceInner.innerProperties = SearchServiceProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedSearchServiceInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedSearchServiceInner.identity = Identity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchServiceInner;
        });
    }
}

