/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models.SBQueueInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.QueueAuthorizationRulesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.ServiceBusNamespaceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Queue;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.QueueAuthorizationRule;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

class QueueImpl
extends IndependentChildResourceImpl<Queue, ServiceBusNamespaceImpl, SBQueueInner, QueueImpl, ServiceBusManager>
implements Queue,
Queue.Definition,
Queue.Update {
    private List<Creatable<QueueAuthorizationRule>> rulesToCreate;
    private List<String> rulesToDelete;

    QueueImpl(String resourceGroupName, String namespaceName, String name, Region region, SBQueueInner inner, ServiceBusManager manager) {
        super(name, inner, manager);
        this.withExistingParentResource(resourceGroupName, namespaceName);
        this.initChildrenOperationsCache();
    }

    @Override
    public OffsetDateTime createdAt() {
        return ((SBQueueInner)this.innerModel()).createdAt();
    }

    @Override
    public OffsetDateTime accessedAt() {
        return ((SBQueueInner)this.innerModel()).accessedAt();
    }

    @Override
    public OffsetDateTime updatedAt() {
        return ((SBQueueInner)this.innerModel()).updatedAt();
    }

    @Override
    public long maxSizeInMB() {
        return ResourceManagerUtils.toPrimitiveLong(((SBQueueInner)this.innerModel()).maxSizeInMegabytes().longValue());
    }

    @Override
    public long currentSizeInBytes() {
        return ResourceManagerUtils.toPrimitiveLong(((SBQueueInner)this.innerModel()).sizeInBytes());
    }

    @Override
    public boolean isBatchedOperationsEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBQueueInner)this.innerModel()).enableBatchedOperations());
    }

    @Override
    public boolean isDeadLetteringEnabledForExpiredMessages() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBQueueInner)this.innerModel()).deadLetteringOnMessageExpiration());
    }

    @Override
    public boolean isExpressEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBQueueInner)this.innerModel()).enableExpress());
    }

    @Override
    public boolean isPartitioningEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBQueueInner)this.innerModel()).enablePartitioning());
    }

    @Override
    public boolean isSessionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBQueueInner)this.innerModel()).requiresSession());
    }

    @Override
    public boolean isDuplicateDetectionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBQueueInner)this.innerModel()).requiresDuplicateDetection());
    }

    @Override
    public long lockDurationInSeconds() {
        if (((SBQueueInner)this.innerModel()).lockDuration() == null) {
            return 0L;
        }
        return ((SBQueueInner)this.innerModel()).lockDuration().getSeconds();
    }

    @Override
    public long deleteOnIdleDurationInMinutes() {
        if (((SBQueueInner)this.innerModel()).autoDeleteOnIdle() == null) {
            return 0L;
        }
        return ((SBQueueInner)this.innerModel()).autoDeleteOnIdle().toMinutes();
    }

    @Override
    public Duration defaultMessageTtlDuration() {
        if (((SBQueueInner)this.innerModel()).defaultMessageTimeToLive() == null) {
            return null;
        }
        return ((SBQueueInner)this.innerModel()).defaultMessageTimeToLive();
    }

    @Override
    public Duration duplicateMessageDetectionHistoryDuration() {
        if (((SBQueueInner)this.innerModel()).duplicateDetectionHistoryTimeWindow() == null) {
            return null;
        }
        return ((SBQueueInner)this.innerModel()).duplicateDetectionHistoryTimeWindow();
    }

    @Override
    public int maxDeliveryCountBeforeDeadLetteringMessage() {
        return ResourceManagerUtils.toPrimitiveInt(((SBQueueInner)this.innerModel()).maxDeliveryCount());
    }

    @Override
    public long messageCount() {
        return ResourceManagerUtils.toPrimitiveLong(((SBQueueInner)this.innerModel()).messageCount());
    }

    @Override
    public long activeMessageCount() {
        if (((SBQueueInner)this.innerModel()).countDetails() == null || ((SBQueueInner)this.innerModel()).countDetails().activeMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBQueueInner)this.innerModel()).countDetails().activeMessageCount());
    }

    @Override
    public long deadLetterMessageCount() {
        if (((SBQueueInner)this.innerModel()).countDetails() == null || ((SBQueueInner)this.innerModel()).countDetails().deadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBQueueInner)this.innerModel()).countDetails().deadLetterMessageCount());
    }

    @Override
    public long scheduledMessageCount() {
        if (((SBQueueInner)this.innerModel()).countDetails() == null || ((SBQueueInner)this.innerModel()).countDetails().scheduledMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBQueueInner)this.innerModel()).countDetails().scheduledMessageCount());
    }

    @Override
    public long transferDeadLetterMessageCount() {
        if (((SBQueueInner)this.innerModel()).countDetails() == null || ((SBQueueInner)this.innerModel()).countDetails().transferDeadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBQueueInner)this.innerModel()).countDetails().transferDeadLetterMessageCount());
    }

    @Override
    public long transferMessageCount() {
        if (((SBQueueInner)this.innerModel()).countDetails() == null || ((SBQueueInner)this.innerModel()).countDetails().transferMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBQueueInner)this.innerModel()).countDetails().transferMessageCount());
    }

    @Override
    public EntityStatus status() {
        return ((SBQueueInner)this.innerModel()).status();
    }

    @Override
    public QueueAuthorizationRulesImpl authorizationRules() {
        return new QueueAuthorizationRulesImpl(this.resourceGroupName(), this.parentName, this.name(), this.region(), (ServiceBusManager)this.manager());
    }

    @Override
    public QueueImpl withSizeInMB(long sizeInMB) {
        ((SBQueueInner)this.innerModel()).withMaxSizeInMegabytes((int)sizeInMB);
        return this;
    }

    @Override
    public QueueImpl withPartitioning() {
        ((SBQueueInner)this.innerModel()).withEnablePartitioning(true);
        return this;
    }

    @Override
    public QueueImpl withoutPartitioning() {
        ((SBQueueInner)this.innerModel()).withEnablePartitioning(false);
        return this;
    }

    @Override
    public QueueImpl withDeleteOnIdleDurationInMinutes(int durationInMinutes) {
        ((SBQueueInner)this.innerModel()).withAutoDeleteOnIdle(Duration.ofMinutes(durationInMinutes));
        return this;
    }

    @Override
    public QueueImpl withMessageLockDurationInSeconds(int durationInSeconds) {
        ((SBQueueInner)this.innerModel()).withLockDuration(Duration.ofSeconds(durationInSeconds));
        return this;
    }

    @Override
    public QueueImpl withDefaultMessageTTL(Duration ttl) {
        ((SBQueueInner)this.innerModel()).withDefaultMessageTimeToLive(ttl);
        return this;
    }

    @Override
    public QueueImpl withSession() {
        ((SBQueueInner)this.innerModel()).withRequiresSession(true);
        return this;
    }

    @Override
    public QueueImpl withoutSession() {
        ((SBQueueInner)this.innerModel()).withRequiresSession(false);
        return this;
    }

    @Override
    public QueueImpl withExpressMessage() {
        ((SBQueueInner)this.innerModel()).withEnableExpress(true);
        return this;
    }

    @Override
    public QueueImpl withoutExpressMessage() {
        ((SBQueueInner)this.innerModel()).withEnableExpress(false);
        return this;
    }

    @Override
    public QueueImpl withMessageBatching() {
        ((SBQueueInner)this.innerModel()).withEnableBatchedOperations(true);
        return this;
    }

    @Override
    public QueueImpl withoutMessageBatching() {
        ((SBQueueInner)this.innerModel()).withEnableBatchedOperations(false);
        return this;
    }

    @Override
    public QueueImpl withExpiredMessageMovedToDeadLetterQueue() {
        ((SBQueueInner)this.innerModel()).withDeadLetteringOnMessageExpiration(true);
        return this;
    }

    @Override
    public QueueImpl withoutExpiredMessageMovedToDeadLetterQueue() {
        ((SBQueueInner)this.innerModel()).withDeadLetteringOnMessageExpiration(false);
        return this;
    }

    @Override
    public QueueImpl withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int deliveryCount) {
        ((SBQueueInner)this.innerModel()).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    @Override
    public QueueImpl withDuplicateMessageDetection(Duration duplicateDetectionHistoryDuration) {
        ((SBQueueInner)this.innerModel()).withRequiresDuplicateDetection(true);
        ((SBQueueInner)this.innerModel()).withDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryDuration);
        return this;
    }

    @Override
    public QueueImpl withDuplicateMessageDetectionHistoryDuration(Duration duration) {
        return this.withDuplicateMessageDetection(duration);
    }

    @Override
    public QueueImpl withoutDuplicateMessageDetection() {
        ((SBQueueInner)this.innerModel()).withRequiresDuplicateDetection(false);
        return this;
    }

    @Override
    public QueueImpl withNewSendRule(String name) {
        this.rulesToCreate.add((Creatable<QueueAuthorizationRule>)this.authorizationRules().define(name).withSendingEnabled());
        return this;
    }

    @Override
    public QueueImpl withNewListenRule(String name) {
        this.rulesToCreate.add((Creatable<QueueAuthorizationRule>)this.authorizationRules().define(name).withListeningEnabled());
        return this;
    }

    @Override
    public QueueImpl withNewManageRule(String name) {
        this.rulesToCreate.add((Creatable<QueueAuthorizationRule>)this.authorizationRules().define(name).withManagementEnabled());
        return this;
    }

    @Override
    public QueueImpl withoutAuthorizationRule(String name) {
        this.rulesToDelete.add(name);
        return this;
    }

    @Override
    protected Mono<SBQueueInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)this.manager()).serviceClient()).getQueues().getAsync(this.resourceGroupName(), this.parentName, this.name());
    }

    @Override
    protected Mono<Queue> createChildResourceAsync() {
        Mono<SBQueueInner> createTask = ((ServiceBusManagementClient)((ServiceBusManager)this.manager()).serviceClient()).getQueues().createOrUpdateAsync(this.resourceGroupName(), this.parentName, this.name(), (SBQueueInner)this.innerModel()).map(inner -> {
            this.setInner(inner);
            return inner;
        });
        Flux<Void> childOperationTasks = this.submitChildrenOperationsAsync();
        QueueImpl self = this;
        return Flux.concat(createTask, childOperationTasks).doOnTerminate(() -> this.initChildrenOperationsCache()).then(Mono.just(self));
    }

    private void initChildrenOperationsCache() {
        this.rulesToCreate = new ArrayList<Creatable<QueueAuthorizationRule>>();
        this.rulesToDelete = new ArrayList<String>();
    }

    private Flux<Void> submitChildrenOperationsAsync() {
        Flux<Object> rulesCreateStream = Flux.empty();
        if (this.rulesToCreate.size() > 0) {
            rulesCreateStream = this.authorizationRules().createAsync(this.rulesToCreate).then().flux();
        }
        Flux<Object> rulesDeleteStream = Flux.empty();
        if (this.rulesToDelete.size() > 0) {
            rulesDeleteStream = this.authorizationRules().deleteByNameAsync(this.rulesToDelete);
        }
        return Flux.mergeDelayError(32, rulesCreateStream, rulesDeleteStream);
    }
}

