/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models.SBNamespaceUpdateProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Encryption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Identity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.ResourceNamespacePatch;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.SBSku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class SBNamespaceUpdateParameters
extends ResourceNamespacePatch {
    private SBSku sku;
    private SBNamespaceUpdateProperties innerProperties;
    private Identity identity;
    private String id;
    private String name;
    private String type;

    public SBSku sku() {
        return this.sku;
    }

    public SBNamespaceUpdateParameters withSku(SBSku sku) {
        this.sku = sku;
        return this;
    }

    private SBNamespaceUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Identity identity() {
        return this.identity;
    }

    public SBNamespaceUpdateParameters withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public SBNamespaceUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SBNamespaceUpdateParameters withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    public OffsetDateTime updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    public String serviceBusEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBusEndpoint();
    }

    public String metricId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricId();
    }

    public Encryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public SBNamespaceUpdateParameters withEncryption(Encryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceUpdateProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public SBNamespaceUpdateParameters withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceUpdateProperties();
        }
        this.innerProperties().withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public SBNamespaceUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceUpdateProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public String alternateName() {
        return this.innerProperties() == null ? null : this.innerProperties().alternateName();
    }

    public SBNamespaceUpdateParameters withAlternateName(String alternateName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceUpdateProperties();
        }
        this.innerProperties().withAlternateName(alternateName);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static SBNamespaceUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SBNamespaceUpdateParameters deserializedSBNamespaceUpdateParameters = new SBNamespaceUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSBNamespaceUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSBNamespaceUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSBNamespaceUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSBNamespaceUpdateParameters.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSBNamespaceUpdateParameters.withTags((Map)tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedSBNamespaceUpdateParameters.sku = SBSku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSBNamespaceUpdateParameters.innerProperties = SBNamespaceUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedSBNamespaceUpdateParameters.identity = Identity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBNamespaceUpdateParameters;
        });
    }
}

