/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ServerAutomaticTuningInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.AutomaticTuningOptionModeDesired;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.AutomaticTuningServerMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.AutomaticTuningServerOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerAutomaticTuning;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class SqlServerAutomaticTuningImpl
extends RefreshableWrapperImpl<ServerAutomaticTuningInner, SqlServerAutomaticTuning>
implements SqlServerAutomaticTuning,
SqlServerAutomaticTuning.Update {
    protected String key;
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlServerAutomaticTuningImpl(SqlServerImpl server, ServerAutomaticTuningInner innerObject) {
        this(server.resourceGroupName(), server.name(), innerObject, (SqlServerManager)server.manager());
    }

    SqlServerAutomaticTuningImpl(String resourceGroupName, String sqlServerName, ServerAutomaticTuningInner innerObject, SqlServerManager sqlServerManager) {
        super(innerObject);
        Objects.requireNonNull(innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.key = UUID.randomUUID().toString();
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public AutomaticTuningServerMode desiredState() {
        return ((ServerAutomaticTuningInner)this.innerModel()).desiredState();
    }

    @Override
    public AutomaticTuningServerMode actualState() {
        return ((ServerAutomaticTuningInner)this.innerModel()).actualState();
    }

    @Override
    public Map<String, AutomaticTuningServerOptions> tuningOptions() {
        return Collections.unmodifiableMap(((ServerAutomaticTuningInner)this.innerModel()).options() != null ? ((ServerAutomaticTuningInner)this.innerModel()).options() : new HashMap());
    }

    @Override
    public SqlServerAutomaticTuningImpl withAutomaticTuningMode(AutomaticTuningServerMode desiredState) {
        ((ServerAutomaticTuningInner)this.innerModel()).withDesiredState(desiredState);
        return this;
    }

    @Override
    public SqlServerAutomaticTuningImpl withAutomaticTuningOption(String tuningOptionName, AutomaticTuningOptionModeDesired desiredState) {
        if (((ServerAutomaticTuningInner)this.innerModel()).options() == null) {
            ((ServerAutomaticTuningInner)this.innerModel()).withOptions(new HashMap<String, AutomaticTuningServerOptions>());
        }
        AutomaticTuningServerOptions item = ((ServerAutomaticTuningInner)this.innerModel()).options().get(tuningOptionName);
        ((ServerAutomaticTuningInner)this.innerModel()).options().put(tuningOptionName, item != null ? item.withDesiredState(desiredState) : new AutomaticTuningServerOptions().withDesiredState(desiredState));
        return this;
    }

    @Override
    public SqlServerAutomaticTuningImpl withAutomaticTuningOptions(Map<String, AutomaticTuningOptionModeDesired> tuningOptions) {
        if (tuningOptions != null) {
            for (Map.Entry<String, AutomaticTuningOptionModeDesired> option : tuningOptions.entrySet()) {
                this.withAutomaticTuningOption(option.getKey(), option.getValue());
            }
        }
        return this;
    }

    @Override
    protected Mono<ServerAutomaticTuningInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerAutomaticTunings().getAsync(this.resourceGroupName, this.sqlServerName);
    }

    @Override
    public SqlServerAutomaticTuning apply() {
        return this.applyAsync().block();
    }

    @Override
    public Mono<SqlServerAutomaticTuning> applyAsync() {
        return this.applyAsync(Context.NONE);
    }

    @Override
    public SqlServerAutomaticTuning apply(Context context) {
        return this.applyAsync(context).block();
    }

    @Override
    public Mono<SqlServerAutomaticTuning> applyAsync(Context context) {
        SqlServerAutomaticTuningImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerAutomaticTunings().updateAsync(this.resourceGroupName, this.sqlServerName, (ServerAutomaticTuningInner)this.innerModel()).contextWrite(c -> c.putAll(FluxUtil.toReactorContext(context).readOnly())).map(serverAutomaticTuningInner -> {
            self.setInner(serverAutomaticTuningInner);
            return self;
        });
    }

    @Override
    public SqlServerAutomaticTuning.Update update() {
        return this;
    }
}

