/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.VirtualNetworkRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlVirtualNetworkRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlVirtualNetworkRuleOperations;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public class SqlVirtualNetworkRuleImpl
extends ExternalChildResourceImpl<SqlVirtualNetworkRule, VirtualNetworkRuleInner, SqlServerImpl, SqlServer>
implements SqlVirtualNetworkRule,
SqlVirtualNetworkRule.SqlVirtualNetworkRuleDefinition<SqlServer.DefinitionStages.WithCreate>,
SqlVirtualNetworkRule.Update,
SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlVirtualNetworkRuleImpl(String name, SqlServerImpl parent, VirtualNetworkRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, parent, innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
    }

    SqlVirtualNetworkRuleImpl(String resourceGroupName, String sqlServerName, String name, VirtualNetworkRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
    }

    SqlVirtualNetworkRuleImpl(String name, VirtualNetworkRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public Mono<SqlVirtualNetworkRule> createResourceAsync() {
        SqlVirtualNetworkRuleImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (VirtualNetworkRuleInner)this.innerModel()).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    @Override
    public Mono<SqlVirtualNetworkRule> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    protected Mono<VirtualNetworkRuleInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public SqlVirtualNetworkRuleImpl update() {
        super.prepareUpdate();
        return this;
    }

    @Override
    public String id() {
        return ((VirtualNetworkRuleInner)this.innerModel()).id();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String subnetId() {
        return ((VirtualNetworkRuleInner)this.innerModel()).virtualNetworkSubnetId();
    }

    @Override
    public String state() {
        return ((VirtualNetworkRuleInner)this.innerModel()).state().toString();
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId(this.id());
    }

    @Override
    public void delete() {
        this.deleteResourceAsync().block();
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    @Override
    public SqlVirtualNetworkRuleImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString(sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl withExistingSqlServer(SqlServer sqlServer) {
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl withSubnet(String networkId, String subnetName) {
        ((VirtualNetworkRuleInner)this.innerModel()).withVirtualNetworkSubnetId(networkId + "/subnets/" + subnetName);
        ((VirtualNetworkRuleInner)this.innerModel()).withIgnoreMissingVnetServiceEndpoint(false);
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl ignoreMissingSqlServiceEndpoint() {
        ((VirtualNetworkRuleInner)this.innerModel()).withIgnoreMissingVnetServiceEndpoint(true);
        return this;
    }

    @Override
    public SqlServer.DefinitionStages.WithCreate attach() {
        return (SqlServer.DefinitionStages.WithCreate)this.parent();
    }
}

