/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Kind;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Restriction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SkuCapability;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SkuTier;
import java.io.IOException;
import java.util.List;

public final class SkuInformationInner
implements JsonSerializable<SkuInformationInner> {
    private SkuName name;
    private SkuTier tier;
    private String resourceType;
    private Kind kind;
    private List<String> locations;
    private List<SkuCapability> capabilities;
    private List<Restriction> restrictions;
    private static final ClientLogger LOGGER = new ClientLogger(SkuInformationInner.class);

    public SkuName name() {
        return this.name;
    }

    public SkuInformationInner withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuTier tier() {
        return this.tier;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Kind kind() {
        return this.kind;
    }

    public List<String> locations() {
        return this.locations;
    }

    public List<SkuCapability> capabilities() {
        return this.capabilities;
    }

    public List<Restriction> restrictions() {
        return this.restrictions;
    }

    public SkuInformationInner withRestrictions(List<Restriction> restrictions) {
        this.restrictions = restrictions;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model SkuInformationInner"));
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.restrictions() != null) {
            this.restrictions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeArrayField("restrictions", this.restrictions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static SkuInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SkuInformationInner deserializedSkuInformationInner = new SkuInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSkuInformationInner.name = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedSkuInformationInner.tier = SkuTier.fromString(reader.getString());
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedSkuInformationInner.resourceType = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSkuInformationInner.kind = Kind.fromString(reader.getString());
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedSkuInformationInner.locations = locations;
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List<SkuCapability> capabilities = reader.readArray(reader1 -> SkuCapability.fromJson(reader1));
                    deserializedSkuInformationInner.capabilities = capabilities;
                    continue;
                }
                if ("restrictions".equals(fieldName)) {
                    List<Restriction> restrictions = reader.readArray(reader1 -> Restriction.fromJson(reader1));
                    deserializedSkuInformationInner.restrictions = restrictions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuInformationInner;
        });
    }
}

