/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ETagState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.BlobContainersClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.ImmutabilityPolicyInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.IdParsingUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ImmutabilityPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ImmutabilityPolicyState;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class ImmutabilityPolicyImpl
extends CreatableUpdatableImpl<ImmutabilityPolicy, ImmutabilityPolicyInner, ImmutabilityPolicyImpl>
implements ImmutabilityPolicy,
ImmutabilityPolicy.Definition,
ImmutabilityPolicy.Update {
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;
    private String containerName;
    private int cImmutabilityPeriodSinceCreationInDays;
    private int uImmutabilityPeriodSinceCreationInDays;
    private final ETagState eTagState = new ETagState();

    ImmutabilityPolicyImpl(StorageManager manager) {
        super("default", new ImmutabilityPolicyInner());
        this.manager = manager;
    }

    ImmutabilityPolicyImpl(ImmutabilityPolicyInner inner, StorageManager manager) {
        super(inner.name(), inner);
        this.manager = manager;
        this.containerName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
        this.containerName = IdParsingUtils.getValueFromIdByName(inner.id(), "containers");
    }

    @Override
    public StorageManager manager() {
        return this.manager;
    }

    @Override
    public Mono<ImmutabilityPolicy> createResourceAsync() {
        BlobContainersClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers();
        return client.createOrUpdateImmutabilityPolicyWithResponseAsync(this.resourceGroupName, this.accountName, this.containerName, null, new ImmutabilityPolicyInner().withImmutabilityPeriodSinceCreationInDays(this.cImmutabilityPeriodSinceCreationInDays)).flatMap(r -> Mono.justOrEmpty(r.getValue())).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<ImmutabilityPolicy> updateResourceAsync() {
        BlobContainersClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers();
        return client.createOrUpdateImmutabilityPolicyWithResponseAsync(this.resourceGroupName, this.accountName, this.containerName, this.eTagState.ifMatchValueOnUpdate(((ImmutabilityPolicyInner)this.innerModel()).etag()), new ImmutabilityPolicyInner().withImmutabilityPeriodSinceCreationInDays(this.uImmutabilityPeriodSinceCreationInDays)).flatMap(r -> Mono.justOrEmpty(r.getValue())).map(this.innerToFluentMap(this)).map(self -> {
            this.eTagState.clear();
            return self;
        });
    }

    @Override
    protected Mono<ImmutabilityPolicyInner> getInnerAsync() {
        BlobContainersClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers();
        return client.getImmutabilityPolicyWithResponseAsync(this.resourceGroupName, this.accountName, this.containerName, null).flatMap(r -> Mono.justOrEmpty(r.getValue()));
    }

    @Override
    public boolean isInCreateMode() {
        return ((ImmutabilityPolicyInner)this.innerModel()).id() == null;
    }

    @Override
    public String etag() {
        return ((ImmutabilityPolicyInner)this.innerModel()).etag();
    }

    @Override
    public String id() {
        return ((ImmutabilityPolicyInner)this.innerModel()).id();
    }

    @Override
    public int immutabilityPeriodSinceCreationInDays() {
        return ResourceManagerUtils.toPrimitiveInt(((ImmutabilityPolicyInner)this.innerModel()).immutabilityPeriodSinceCreationInDays());
    }

    @Override
    public String name() {
        return ((ImmutabilityPolicyInner)this.innerModel()).name();
    }

    @Override
    public ImmutabilityPolicyState state() {
        return ((ImmutabilityPolicyInner)this.innerModel()).state();
    }

    @Override
    public String type() {
        return ((ImmutabilityPolicyInner)this.innerModel()).type();
    }

    @Override
    public void lock() {
        this.lockAsync().block();
    }

    @Override
    public Mono<Void> lockAsync() {
        return this.manager().blobContainers().lockImmutabilityPolicyAsync(this.resourceGroupName, this.accountName, this.containerName, this.etag()).map(p -> {
            this.setInner((ImmutabilityPolicyInner)p.innerModel());
            return p;
        }).then();
    }

    @Override
    public void extend(int immutabilityPeriodSinceCreationInDays) {
        this.extendAsync(immutabilityPeriodSinceCreationInDays).block();
    }

    @Override
    public Mono<Void> extendAsync(int immutabilityPeriodSinceCreationInDays) {
        return this.manager().blobContainers().extendImmutabilityPolicyAsync(this.resourceGroupName, this.accountName, this.containerName, immutabilityPeriodSinceCreationInDays, ((ImmutabilityPolicyInner)this.innerModel()).allowProtectedAppendWrites(), this.etag()).map(p -> {
            this.setInner((ImmutabilityPolicyInner)p.innerModel());
            return p;
        }).then();
    }

    @Override
    public ImmutabilityPolicyImpl withExistingContainer(String resourceGroupName, String accountName, String containerName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.containerName = containerName;
        return this;
    }

    @Override
    public ImmutabilityPolicyImpl withETagCheck() {
        this.eTagState.withImplicitETagCheckOnCreateOrUpdate(this.isInCreateMode());
        return this;
    }

    @Override
    public ImmutabilityPolicyImpl withETagCheck(String eTagValue) {
        this.eTagState.withExplicitETagCheckOnUpdate(eTagValue);
        return this;
    }

    @Override
    public ImmutabilityPolicyImpl withImmutabilityPeriodSinceCreationInDays(int immutabilityPeriodSinceCreationInDays) {
        if (this.isInCreateMode()) {
            this.cImmutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays;
        } else {
            this.uImmutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays;
        }
        return this;
    }
}

