/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.StorageAccountImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Identity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.IdentityType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.UserAssignedIdentity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

class StorageAccountMsiHandler
extends RoleAssignmentHelper {
    private final StorageAccountImpl storageAccount;
    private List<String> creatableIdentityKeys;
    private Map<String, UserAssignedIdentity> userAssignedIdentities;
    private final ClientLogger logger = new ClientLogger(StorageAccountMsiHandler.class);

    StorageAccountMsiHandler(AuthorizationManager authorizationManager, StorageAccountImpl storageAccount) {
        super(authorizationManager, storageAccount.taskGroup(), storageAccount.idProvider());
        this.storageAccount = storageAccount;
        this.creatableIdentityKeys = new ArrayList<String>();
        this.userAssignedIdentities = new HashMap<String, UserAssignedIdentity>();
    }

    StorageAccountMsiHandler withLocalManagedServiceIdentity() {
        this.initStorageAccountIdentity(IdentityType.SYSTEM_ASSIGNED, false);
        return this;
    }

    StorageAccountMsiHandler withoutLocalManagedServiceIdentity() {
        if (((StorageAccountInner)this.storageAccount.innerModel()).identity() == null || ((StorageAccountInner)this.storageAccount.innerModel()).identity().type() == null || IdentityType.NONE.equals(((StorageAccountInner)this.storageAccount.innerModel()).identity().type()) || IdentityType.USER_ASSIGNED.equals(((StorageAccountInner)this.storageAccount.innerModel()).identity().type())) {
            return this;
        }
        this.initStorageAccountIdentity(IdentityType.SYSTEM_ASSIGNED, true);
        return this;
    }

    StorageAccountMsiHandler withNewExternalManagedServiceIdentity(Creatable<com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.models.Identity> creatableIdentity) {
        this.initStorageAccountIdentity(IdentityType.USER_ASSIGNED, false);
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatableIdentity);
        Objects.requireNonNull(dependency);
        this.storageAccount.taskGroup().addDependency(dependency);
        this.creatableIdentityKeys.add(creatableIdentity.key());
        return this;
    }

    StorageAccountMsiHandler withExistingExternalManagedServiceIdentity(com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.models.Identity identity) {
        this.initStorageAccountIdentity(IdentityType.USER_ASSIGNED, false);
        this.userAssignedIdentities.put(identity.id(), new UserAssignedIdentity());
        return this;
    }

    StorageAccountMsiHandler withExistingExternalManagedServiceIdentity(String identityId) {
        this.initStorageAccountIdentity(IdentityType.USER_ASSIGNED, false);
        this.userAssignedIdentities.put(identityId, new UserAssignedIdentity());
        return this;
    }

    StorageAccountMsiHandler withoutExternalManagedServiceIdentity(String identityId) {
        if (((StorageAccountInner)this.storageAccount.innerModel()).identity() == null || ((StorageAccountInner)this.storageAccount.innerModel()).identity().type() == null || IdentityType.NONE.equals(((StorageAccountInner)this.storageAccount.innerModel()).identity().type()) || IdentityType.SYSTEM_ASSIGNED.equals(((StorageAccountInner)this.storageAccount.innerModel()).identity().type())) {
            return this;
        }
        this.initStorageAccountIdentity(IdentityType.USER_ASSIGNED, true);
        this.userAssignedIdentities.put(identityId, null);
        return this;
    }

    void processCreatedExternalIdentities() {
        for (String key : this.creatableIdentityKeys) {
            com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.models.Identity identity = (com.dataiku.dss.shadelibazure.com.azure.resourcemanager.msi.models.Identity)this.storageAccount.taskGroup().taskResult(key);
            Objects.requireNonNull(identity);
            this.userAssignedIdentities.put(identity.id(), new UserAssignedIdentity());
        }
        this.creatableIdentityKeys.clear();
    }

    void handleExternalIdentities() {
        if (this.storageAccount.isInCreateMode()) {
            if (!this.userAssignedIdentities.isEmpty()) {
                this.storageAccount.createParameters.identity().withUserAssignedIdentities(this.userAssignedIdentities);
            }
        } else if (!this.handleRemoveAllExternalIdentitiesCase()) {
            if (!this.userAssignedIdentities.isEmpty()) {
                this.storageAccount.updateParameters.identity().withUserAssignedIdentities(this.userAssignedIdentities);
            } else if (this.storageAccount.updateParameters.identity() != null) {
                this.storageAccount.updateParameters.identity().withUserAssignedIdentities(null);
            }
        }
    }

    void clear() {
        this.userAssignedIdentities = new HashMap<String, UserAssignedIdentity>();
    }

    private boolean handleRemoveAllExternalIdentitiesCase() {
        if (!this.userAssignedIdentities.isEmpty()) {
            boolean containsRemoveOnly;
            int rmCount = 0;
            for (UserAssignedIdentity v : this.userAssignedIdentities.values()) {
                if (v != null) break;
                ++rmCount;
            }
            boolean bl = containsRemoveOnly = rmCount > 0 && rmCount == this.userAssignedIdentities.size();
            if (containsRemoveOnly) {
                boolean bl2;
                HashSet<String> currentIds = new HashSet<String>();
                Identity currentIdentity = this.storageAccount.updateParameters.identity();
                if (currentIdentity != null && currentIdentity.userAssignedIdentities() != null) {
                    for (String string : currentIdentity.userAssignedIdentities().keySet()) {
                        currentIds.add(string.toLowerCase(Locale.ROOT));
                    }
                }
                HashSet<String> removeIds = new HashSet<String>();
                for (Map.Entry<String, UserAssignedIdentity> entrySet : this.userAssignedIdentities.entrySet()) {
                    if (entrySet.getValue() != null) continue;
                    removeIds.add(entrySet.getKey().toLowerCase(Locale.ROOT));
                }
                boolean bl3 = bl2 = currentIds.size() == removeIds.size() && currentIds.containsAll(removeIds);
                if (bl2) {
                    if (currentIdentity == null || currentIdentity.type() == null) {
                        this.storageAccount.updateParameters.withIdentity(new Identity().withType(IdentityType.NONE));
                    } else if (currentIdentity.type().equals(IdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
                        this.storageAccount.updateParameters.identity().withType(IdentityType.SYSTEM_ASSIGNED);
                    } else if (currentIdentity.type().equals(IdentityType.USER_ASSIGNED)) {
                        this.storageAccount.updateParameters.identity().withType(IdentityType.NONE);
                    }
                    this.storageAccount.updateParameters.identity().withUserAssignedIdentities(null);
                    return true;
                }
                if (currentIds.isEmpty() && !removeIds.isEmpty() && currentIdentity == null) {
                    this.storageAccount.updateParameters.withIdentity(new Identity().withType(IdentityType.NONE).withUserAssignedIdentities(null));
                    return true;
                }
            }
        }
        return false;
    }

    private void initStorageAccountIdentity(IdentityType identityType, Boolean isWithout) {
        if (!identityType.equals(IdentityType.USER_ASSIGNED) && !identityType.equals(IdentityType.SYSTEM_ASSIGNED)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Invalid argument: " + identityType));
        }
        if (this.storageAccount.isInCreateMode()) {
            if (Objects.isNull(this.storageAccount.createParameters.identity())) {
                this.storageAccount.createParameters.withIdentity(new Identity());
            }
            if (Objects.isNull(this.storageAccount.createParameters.identity().type()) || this.storageAccount.createParameters.identity().type().equals(IdentityType.NONE) || this.storageAccount.createParameters.identity().type().equals(identityType)) {
                this.storageAccount.createParameters.identity().withType(identityType);
            } else {
                this.storageAccount.createParameters.identity().withType(IdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED);
            }
        } else {
            if (Objects.isNull(this.storageAccount.updateParameters.identity())) {
                this.storageAccount.updateParameters.withIdentity(((StorageAccountInner)this.storageAccount.innerModel()).identity());
            }
            if (isWithout.booleanValue()) {
                if (IdentityType.SYSTEM_ASSIGNED.equals(identityType)) {
                    if (IdentityType.SYSTEM_ASSIGNED.equals(this.storageAccount.updateParameters.identity().type())) {
                        this.storageAccount.updateParameters.identity().withType(IdentityType.NONE);
                    } else {
                        this.storageAccount.updateParameters.identity().withType(IdentityType.USER_ASSIGNED);
                    }
                }
            } else {
                if (Objects.isNull(this.storageAccount.updateParameters.identity())) {
                    this.storageAccount.updateParameters.withIdentity(new Identity());
                }
                if (Objects.isNull(this.storageAccount.updateParameters.identity().type()) || this.storageAccount.updateParameters.identity().type().equals(IdentityType.NONE) || this.storageAccount.updateParameters.identity().type().equals(identityType)) {
                    this.storageAccount.updateParameters.identity().withType(identityType);
                } else {
                    this.storageAccount.updateParameters.identity().withType(IdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED);
                }
            }
        }
    }
}

