/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.StorageAccountsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.ListServiceSasResponseInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.StorageAccountImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.CheckNameAvailabilityResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ServiceSasParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageAccount;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageAccountCheckNameAvailabilityParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageAccountSkuType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageAccounts;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class StorageAccountsImpl
extends TopLevelModifiableResourcesImpl<StorageAccount, StorageAccountImpl, StorageAccountInner, StorageAccountsClient, StorageManager>
implements StorageAccounts {
    private final AuthorizationManager authorizationManager;

    public StorageAccountsImpl(StorageManager storageManager, AuthorizationManager authorizationManager) {
        super(((StorageManagementClient)storageManager.serviceClient()).getStorageAccounts(), storageManager);
        this.authorizationManager = authorizationManager;
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return this.checkNameAvailabilityAsync(name).block();
    }

    @Override
    public Mono<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        return ((StorageAccountsClient)this.inner()).checkNameAvailabilityAsync(new StorageAccountCheckNameAvailabilityParameters().withName(name)).map(CheckNameAvailabilityResult::new);
    }

    @Override
    public StorageAccountImpl define(String name) {
        return this.wrapModel(name).withSku(StorageAccountSkuType.STANDARD_RAGRS).withGeneralPurposeAccountKindV2().withOnlyHttpsTraffic().withMinimumTlsVersion(MinimumTlsVersion.TLS1_2).withBlobEncryption().withFileEncryption();
    }

    @Override
    protected StorageAccountImpl wrapModel(String name) {
        return new StorageAccountImpl(name, new StorageAccountInner(), (StorageManager)this.manager(), this.authorizationManager);
    }

    @Override
    protected StorageAccountImpl wrapModel(StorageAccountInner storageAccountInner) {
        if (storageAccountInner == null) {
            return null;
        }
        return new StorageAccountImpl(storageAccountInner.name(), storageAccountInner, (StorageManager)this.manager(), this.authorizationManager);
    }

    @Override
    public String createSasToken(String resourceGroupName, String accountName, ServiceSasParameters parameters) {
        return this.createSasTokenAsync(resourceGroupName, accountName, parameters).block();
    }

    @Override
    public Mono<String> createSasTokenAsync(String resourceGroupName, String accountName, ServiceSasParameters parameters) {
        return ((StorageAccountsClient)this.inner()).listServiceSasAsync(resourceGroupName, accountName, parameters).map(ListServiceSasResponseInner::serviceSasToken);
    }

    @Override
    public void failover(String resourceGroupName, String accountName) {
        this.failoverAsync(resourceGroupName, accountName).block();
    }

    @Override
    public Mono<Void> failoverAsync(String resourceGroupName, String accountName) {
        return ((StorageAccountsClient)this.inner()).failoverAsync(resourceGroupName, accountName);
    }
}

