/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.SkuInformationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Kind;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Restriction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SkuCapability;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SkuTier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageAccountSkuType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageResourceType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageSku;
import java.util.ArrayList;
import java.util.List;

class StorageSkuImpl
implements StorageSku {
    private final SkuInformationInner inner;

    StorageSkuImpl(SkuInformationInner skuInner) {
        this.inner = skuInner;
    }

    @Override
    public SkuName name() {
        return this.inner.name();
    }

    @Override
    public SkuTier tier() {
        return this.inner.tier();
    }

    @Override
    public StorageResourceType resourceType() {
        if (this.inner.resourceType() != null) {
            return StorageResourceType.fromString(this.inner.resourceType());
        }
        return null;
    }

    @Override
    public List<Region> regions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        if (this.inner.locations() != null) {
            for (String location : this.inner.locations()) {
                regions.add(Region.fromName(location));
            }
        }
        return regions;
    }

    @Override
    public List<SkuCapability> capabilities() {
        if (this.inner.capabilities() != null) {
            return this.inner.capabilities();
        }
        return new ArrayList<SkuCapability>();
    }

    @Override
    public List<Restriction> restrictions() {
        if (this.inner.restrictions() != null) {
            return this.inner.restrictions();
        }
        return new ArrayList<Restriction>();
    }

    @Override
    public Kind storageAccountKind() {
        return this.inner.kind();
    }

    @Override
    public StorageAccountSkuType storageAccountSku() {
        if (this.resourceType() != null && this.resourceType().equals(StorageResourceType.STORAGE_ACCOUNTS)) {
            return StorageAccountSkuType.fromSkuName(this.inner.name());
        }
        return null;
    }

    @Override
    public SkuInformationInner innerModel() {
        return this.inner;
    }
}

