/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class KeyVaultProperties
implements JsonSerializable<KeyVaultProperties> {
    private String keyName;
    private String keyVersion;
    private String keyVaultUri;
    private String currentVersionedKeyIdentifier;
    private OffsetDateTime lastKeyRotationTimestamp;
    private OffsetDateTime currentVersionedKeyExpirationTimestamp;

    public String keyName() {
        return this.keyName;
    }

    public KeyVaultProperties withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String keyVersion() {
        return this.keyVersion;
    }

    public KeyVaultProperties withKeyVersion(String keyVersion) {
        this.keyVersion = keyVersion;
        return this;
    }

    public String keyVaultUri() {
        return this.keyVaultUri;
    }

    public KeyVaultProperties withKeyVaultUri(String keyVaultUri) {
        this.keyVaultUri = keyVaultUri;
        return this;
    }

    public String currentVersionedKeyIdentifier() {
        return this.currentVersionedKeyIdentifier;
    }

    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    public OffsetDateTime currentVersionedKeyExpirationTimestamp() {
        return this.currentVersionedKeyExpirationTimestamp;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyname", this.keyName);
        jsonWriter.writeStringField("keyversion", this.keyVersion);
        jsonWriter.writeStringField("keyvaulturi", this.keyVaultUri);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultProperties deserializedKeyVaultProperties = new KeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyname".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyName = reader.getString();
                    continue;
                }
                if ("keyversion".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVersion = reader.getString();
                    continue;
                }
                if ("keyvaulturi".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyVaultUri = reader.getString();
                    continue;
                }
                if ("currentVersionedKeyIdentifier".equals(fieldName)) {
                    deserializedKeyVaultProperties.currentVersionedKeyIdentifier = reader.getString();
                    continue;
                }
                if ("lastKeyRotationTimestamp".equals(fieldName)) {
                    deserializedKeyVaultProperties.lastKeyRotationTimestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("currentVersionedKeyExpirationTimestamp".equals(fieldName)) {
                    deserializedKeyVaultProperties.currentVersionedKeyExpirationTimestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultProperties;
        });
    }
}

