/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SkuTier;
import java.io.IOException;

public final class Sku
implements JsonSerializable<Sku> {
    private SkuName name;
    private SkuTier tier;
    private static final ClientLogger LOGGER = new ClientLogger(Sku.class);

    public SkuName name() {
        return this.name;
    }

    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuTier tier() {
        return this.tier;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model Sku"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static Sku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Sku deserializedSku = new Sku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSku.name = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedSku.tier = SkuTier.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSku;
        });
    }
}

