/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.models.EndpointInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.AllowedEndpointRecordType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.DnsConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.MonitorConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.ProfileStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficRoutingMethod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficViewEnrollmentStatus;
import java.io.IOException;
import java.util.List;

public final class ProfileProperties
implements JsonSerializable<ProfileProperties> {
    private ProfileStatus profileStatus;
    private TrafficRoutingMethod trafficRoutingMethod;
    private DnsConfig dnsConfig;
    private MonitorConfig monitorConfig;
    private List<EndpointInner> endpoints;
    private TrafficViewEnrollmentStatus trafficViewEnrollmentStatus;
    private List<AllowedEndpointRecordType> allowedEndpointRecordTypes;
    private Long maxReturn;

    public ProfileStatus profileStatus() {
        return this.profileStatus;
    }

    public ProfileProperties withProfileStatus(ProfileStatus profileStatus) {
        this.profileStatus = profileStatus;
        return this;
    }

    public TrafficRoutingMethod trafficRoutingMethod() {
        return this.trafficRoutingMethod;
    }

    public ProfileProperties withTrafficRoutingMethod(TrafficRoutingMethod trafficRoutingMethod) {
        this.trafficRoutingMethod = trafficRoutingMethod;
        return this;
    }

    public DnsConfig dnsConfig() {
        return this.dnsConfig;
    }

    public ProfileProperties withDnsConfig(DnsConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
        return this;
    }

    public MonitorConfig monitorConfig() {
        return this.monitorConfig;
    }

    public ProfileProperties withMonitorConfig(MonitorConfig monitorConfig) {
        this.monitorConfig = monitorConfig;
        return this;
    }

    public List<EndpointInner> endpoints() {
        return this.endpoints;
    }

    public ProfileProperties withEndpoints(List<EndpointInner> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public TrafficViewEnrollmentStatus trafficViewEnrollmentStatus() {
        return this.trafficViewEnrollmentStatus;
    }

    public ProfileProperties withTrafficViewEnrollmentStatus(TrafficViewEnrollmentStatus trafficViewEnrollmentStatus) {
        this.trafficViewEnrollmentStatus = trafficViewEnrollmentStatus;
        return this;
    }

    public List<AllowedEndpointRecordType> allowedEndpointRecordTypes() {
        return this.allowedEndpointRecordTypes;
    }

    public ProfileProperties withAllowedEndpointRecordTypes(List<AllowedEndpointRecordType> allowedEndpointRecordTypes) {
        this.allowedEndpointRecordTypes = allowedEndpointRecordTypes;
        return this;
    }

    public Long maxReturn() {
        return this.maxReturn;
    }

    public ProfileProperties withMaxReturn(Long maxReturn) {
        this.maxReturn = maxReturn;
        return this;
    }

    public void validate() {
        if (this.dnsConfig() != null) {
            this.dnsConfig().validate();
        }
        if (this.monitorConfig() != null) {
            this.monitorConfig().validate();
        }
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("profileStatus", this.profileStatus == null ? null : this.profileStatus.toString());
        jsonWriter.writeStringField("trafficRoutingMethod", this.trafficRoutingMethod == null ? null : this.trafficRoutingMethod.toString());
        jsonWriter.writeJsonField("dnsConfig", this.dnsConfig);
        jsonWriter.writeJsonField("monitorConfig", this.monitorConfig);
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("trafficViewEnrollmentStatus", this.trafficViewEnrollmentStatus == null ? null : this.trafficViewEnrollmentStatus.toString());
        jsonWriter.writeArrayField("allowedEndpointRecordTypes", this.allowedEndpointRecordTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeNumberField("maxReturn", this.maxReturn);
        return jsonWriter.writeEndObject();
    }

    public static ProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProfileProperties deserializedProfileProperties = new ProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("profileStatus".equals(fieldName)) {
                    deserializedProfileProperties.profileStatus = ProfileStatus.fromString(reader.getString());
                    continue;
                }
                if ("trafficRoutingMethod".equals(fieldName)) {
                    deserializedProfileProperties.trafficRoutingMethod = TrafficRoutingMethod.fromString(reader.getString());
                    continue;
                }
                if ("dnsConfig".equals(fieldName)) {
                    deserializedProfileProperties.dnsConfig = DnsConfig.fromJson(reader);
                    continue;
                }
                if ("monitorConfig".equals(fieldName)) {
                    deserializedProfileProperties.monitorConfig = MonitorConfig.fromJson(reader);
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List<EndpointInner> endpoints = reader.readArray(reader1 -> EndpointInner.fromJson(reader1));
                    deserializedProfileProperties.endpoints = endpoints;
                    continue;
                }
                if ("trafficViewEnrollmentStatus".equals(fieldName)) {
                    deserializedProfileProperties.trafficViewEnrollmentStatus = TrafficViewEnrollmentStatus.fromString(reader.getString());
                    continue;
                }
                if ("allowedEndpointRecordTypes".equals(fieldName)) {
                    List<AllowedEndpointRecordType> allowedEndpointRecordTypes = reader.readArray(reader1 -> AllowedEndpointRecordType.fromString(reader1.getString()));
                    deserializedProfileProperties.allowedEndpointRecordTypes = allowedEndpointRecordTypes;
                    continue;
                }
                if ("maxReturn".equals(fieldName)) {
                    deserializedProfileProperties.maxReturn = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProfileProperties;
        });
    }
}

