/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation;

import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.ICryptoTransform;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.RsaEncryption;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

class RsaOaep
extends RsaEncryption {
    static final String RSAOAEP = "RSA/ECB/OAEPWithSHA1AndMGF1Padding";
    public static final String ALGORITHM_NAME = "RSA-OAEP";

    RsaOaep() {
        super(ALGORITHM_NAME);
    }

    @Override
    public ICryptoTransform createEncryptor(KeyPair keyPair) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return this.createEncryptor(keyPair, null);
    }

    @Override
    public ICryptoTransform createEncryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return new RsaOaepEncryptor(keyPair, provider);
    }

    @Override
    public ICryptoTransform createDecryptor(KeyPair keyPair) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return this.createDecryptor(keyPair, null);
    }

    @Override
    public ICryptoTransform createDecryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return new RsaOaepDecryptor(keyPair, provider);
    }

    static class RsaOaepEncryptor
    implements ICryptoTransform {
        private final Cipher cipher;

        RsaOaepEncryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
            this.cipher = provider == null ? Cipher.getInstance(RsaOaep.RSAOAEP) : Cipher.getInstance(RsaOaep.RSAOAEP, provider);
            this.cipher.init(1, keyPair.getPublic());
        }

        @Override
        public byte[] doFinal(byte[] plaintext) throws IllegalBlockSizeException, BadPaddingException {
            return this.cipher.doFinal(plaintext);
        }
    }

    static class RsaOaepDecryptor
    implements ICryptoTransform {
        private final Cipher cipher;

        RsaOaepDecryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
            this.cipher = provider == null ? Cipher.getInstance(RsaOaep.RSAOAEP) : Cipher.getInstance(RsaOaep.RSAOAEP, provider);
            this.cipher.init(2, keyPair.getPrivate());
        }

        @Override
        public byte[] doFinal(byte[] plaintext) throws IllegalBlockSizeException, BadPaddingException {
            return this.cipher.doFinal(plaintext);
        }
    }
}

