/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.exception.HttpResponseException;
import com.dataiku.dss.shadelibazure.com.azure.core.exception.ResourceModifiedException;
import com.dataiku.dss.shadelibazure.com.azure.core.exception.ResourceNotFoundException;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyVaultErrorException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class KeyVaultKeysUtils {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultKeysUtils.class);

    public static CryptographyClientBuilder getCryptographyClientBuilder(String keyName, String keyVersion, String vaultUrl, HttpPipeline httpPipeline, KeyServiceVersion serviceVersion) {
        if (CoreUtils.isNullOrEmpty(keyName)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'keyName' cannot be null or empty."));
        }
        return new CryptographyClientBuilder().keyIdentifier(KeyVaultKeysUtils.generateKeyId(keyName, keyVersion, vaultUrl)).pipeline(httpPipeline).serviceVersion(CryptographyServiceVersion.valueOf(serviceVersion.name()));
    }

    private static String generateKeyId(String keyName, String keyVersion, String vaultUrl) {
        StringBuilder stringBuilder = new StringBuilder(vaultUrl);
        if (!vaultUrl.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("keys/").append(keyName);
        if (!CoreUtils.isNullOrEmpty(keyVersion)) {
            stringBuilder.append("/").append(keyVersion);
        }
        return stringBuilder.toString();
    }

    public static <T> T callWithMappedException(Supplier<T> call, Function<KeyVaultErrorException, HttpResponseException> exceptionMapper) {
        try {
            return call.get();
        }
        catch (KeyVaultErrorException ex) {
            throw exceptionMapper.apply(ex);
        }
    }

    public static HttpResponseException mapGetKeyException(KeyVaultErrorException ex) {
        if (ex.getResponse().getStatusCode() == 403) {
            return new ResourceModifiedException(ex.getMessage(), ex.getResponse(), ex.getValue());
        }
        if (ex.getResponse().getStatusCode() == 404) {
            return new ResourceNotFoundException(ex.getMessage(), ex.getResponse(), ex.getValue());
        }
        return ex;
    }

    public static void unpackId(String id, Consumer<String> nameConsumer, Consumer<String> versionConsumer) {
        if (CoreUtils.isNullOrEmpty(id)) {
            return;
        }
        try {
            URL url = new URL(id);
            String[] tokens = url.getPath().split("/");
            if (tokens.length >= 3) {
                nameConsumer.accept(tokens[2]);
            }
            if (tokens.length >= 4) {
                versionConsumer.accept(tokens[3]);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.error("Received Malformed Secret Id URL from KV Service");
        }
    }

    public static OffsetDateTime epochToOffsetDateTime(JsonReader epochReader) throws IOException {
        Instant instant = Instant.ofEpochMilli(epochReader.getLong() * 1000L);
        return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    public static String base64UrlJsonSerialization(byte[] value) {
        if (value == null) {
            return null;
        }
        if (value.length == 0) {
            return "";
        }
        return Base64.getUrlEncoder().withoutPadding().encodeToString(value);
    }

    public static byte[] base64UrlJsonDeserialization(String value) {
        return value == null ? null : Base64.getUrlDecoder().decode(value);
    }
}

