/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.JsonWebKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyReleasePolicy;
import java.io.IOException;
import java.util.Map;

public final class KeyImportParameters
implements JsonSerializable<KeyImportParameters> {
    private Boolean hsm;
    private JsonWebKey key;
    private KeyAttributes keyAttributes;
    private Map<String, String> tags;
    private KeyReleasePolicy releasePolicy;

    public Boolean isHsm() {
        return this.hsm;
    }

    public KeyImportParameters setHsm(Boolean hsm) {
        this.hsm = hsm;
        return this;
    }

    public JsonWebKey getKey() {
        return this.key;
    }

    public KeyImportParameters setKey(JsonWebKey key) {
        this.key = key;
        return this;
    }

    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    public KeyImportParameters setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public KeyImportParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    public KeyImportParameters setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", this.key);
        jsonWriter.writeBooleanField("Hsm", this.hsm);
        jsonWriter.writeJsonField("attributes", this.keyAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("release_policy", this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    public static KeyImportParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyImportParameters deserializedKeyImportParameters = new KeyImportParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedKeyImportParameters.key = JsonWebKey.fromJson(reader);
                    continue;
                }
                if ("Hsm".equals(fieldName)) {
                    deserializedKeyImportParameters.hsm = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedKeyImportParameters.keyAttributes = KeyAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKeyImportParameters.tags = tags;
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    deserializedKeyImportParameters.releasePolicy = KeyReleasePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyImportParameters;
        });
    }
}

