/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyReleasePolicy;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class KeyUpdateParameters
implements JsonSerializable<KeyUpdateParameters> {
    private List<KeyOperation> keyOps;
    private KeyAttributes keyAttributes;
    private Map<String, String> tags;
    private KeyReleasePolicy releasePolicy;

    public List<KeyOperation> getKeyOps() {
        return this.keyOps;
    }

    public KeyUpdateParameters setKeyOps(List<KeyOperation> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    public KeyUpdateParameters setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public KeyUpdateParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    public KeyUpdateParameters setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("key_ops", this.keyOps, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("attributes", this.keyAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("release_policy", this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    public static KeyUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyUpdateParameters deserializedKeyUpdateParameters = new KeyUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key_ops".equals(fieldName)) {
                    List<KeyOperation> keyOps = reader.readArray(reader1 -> KeyOperation.fromString(reader1.getString()));
                    deserializedKeyUpdateParameters.keyOps = keyOps;
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedKeyUpdateParameters.keyAttributes = KeyAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKeyUpdateParameters.tags = tags;
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    deserializedKeyUpdateParameters.releasePolicy = KeyReleasePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyUpdateParameters;
        });
    }
}

