/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

public final class SecretProperties
implements JsonSerializable<SecretProperties> {
    String id;
    String version;
    Boolean enabled;
    OffsetDateTime notBefore;
    OffsetDateTime expiresOn;
    OffsetDateTime createdOn;
    OffsetDateTime updatedOn;
    String name;
    String recoveryLevel;
    String contentType;
    Map<String, String> tags;
    String keyId;
    Boolean managed;
    Integer recoverableDays;

    SecretProperties(String secretName) {
        this.name = secretName;
    }

    public SecretProperties() {
    }

    public String getName() {
        return this.name;
    }

    public String getRecoveryLevel() {
        return this.recoveryLevel;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public SecretProperties setEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled);
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime getNotBefore() {
        return this.notBefore;
    }

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    public SecretProperties setNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        if (this.expiresOn == null) {
            return null;
        }
        return this.expiresOn;
    }

    public SecretProperties setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    public String getId() {
        return this.id;
    }

    public String getContentType() {
        return this.contentType;
    }

    public SecretProperties setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public SecretProperties setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("contentType", this.contentType).writeMapField("tags", this.tags, JsonWriter::writeString).writeEndObject();
    }

    public static SecretProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretProperties secretProperties = new SecretProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentType".equals(fieldName)) {
                    secretProperties.contentType = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    secretProperties.tags = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    secretProperties.keyId = reader.getString();
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    secretProperties.managed = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("recoverableDays".equals(fieldName)) {
                    secretProperties.recoverableDays = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("attributes".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    SecretProperties.deserializeAttributes(reader, secretProperties);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    secretProperties.id = reader.getString();
                    KeyVaultKeysUtils.unpackId(secretProperties.id, name -> {
                        secretProperties.name = name;
                    }, version -> {
                        secretProperties.version = version;
                    });
                    continue;
                }
                reader.skipChildren();
            }
            return secretProperties;
        });
    }

    static void deserializeAttributes(JsonReader reader, SecretProperties secretProperties) throws IOException {
        while (reader.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = reader.getFieldName();
            reader.nextToken();
            if ("enabled".equals(fieldName)) {
                secretProperties.enabled = reader.getNullable(JsonReader::getBoolean);
                continue;
            }
            if ("nbf".equals(fieldName)) {
                secretProperties.notBefore = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                continue;
            }
            if ("exp".equals(fieldName)) {
                secretProperties.expiresOn = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                continue;
            }
            if ("created".equals(fieldName)) {
                secretProperties.createdOn = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                continue;
            }
            if ("updated".equals(fieldName)) {
                secretProperties.updatedOn = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                continue;
            }
            if ("recoveryLevel".equals(fieldName)) {
                secretProperties.recoveryLevel = reader.getString();
                continue;
            }
            if ("contentType".equals(fieldName)) {
                String contentType = reader.getString();
                secretProperties.contentType = contentType == null ? secretProperties.contentType : contentType;
                continue;
            }
            if ("keyId".equals(fieldName)) {
                String keyId = reader.getString();
                secretProperties.keyId = keyId == null ? secretProperties.keyId : keyId;
                continue;
            }
            if ("tags".equals(fieldName)) {
                Map<String, String> tags = reader.readMap(JsonReader::getString);
                secretProperties.tags = tags == null ? secretProperties.tags : tags;
                continue;
            }
            if ("managed".equals(fieldName)) {
                Boolean managed = reader.getNullable(JsonReader::getBoolean);
                secretProperties.managed = managed == null ? secretProperties.managed : managed;
                continue;
            }
            if ("recoverableDays".equals(fieldName)) {
                secretProperties.recoverableDays = reader.getNullable(JsonReader::getInt);
                continue;
            }
            if ("id".equals(fieldName)) {
                secretProperties.id = reader.getString();
                KeyVaultKeysUtils.unpackId(secretProperties.id, name -> {
                    secretProperties.name = name;
                }, version -> {
                    secretProperties.version = version;
                });
                continue;
            }
            reader.skipChildren();
        }
    }
}

