/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Base64;
import java.util.Objects;

public final class KeyReleasePolicy
implements JsonSerializable<KeyReleasePolicy> {
    private final BinaryData encodedPolicy;
    private String contentType;
    private Boolean immutable;

    KeyReleasePolicy(BinaryData encodedPolicy, boolean ignored) {
        this.encodedPolicy = null;
    }

    public KeyReleasePolicy(BinaryData encodedPolicy) {
        Objects.requireNonNull(encodedPolicy, "'encodedPolicy' cannot be null.");
        this.encodedPolicy = encodedPolicy;
    }

    public BinaryData getEncodedPolicy() {
        return this.encodedPolicy;
    }

    public String getContentType() {
        return this.contentType;
    }

    public KeyReleasePolicy setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Boolean isImmutable() {
        return this.immutable;
    }

    public KeyReleasePolicy setImmutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        byte[] bytes;
        jsonWriter.writeStartObject();
        String encodedPolicyText = this.encodedPolicy == null ? null : ((bytes = this.encodedPolicy.toBytes()) == null ? null : (bytes.length == 0 ? "" : Base64.getUrlEncoder().withoutPadding().encodeToString(bytes)));
        jsonWriter.writeStringField("data", encodedPolicyText);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeBooleanField("immutable", this.immutable);
        return jsonWriter.writeEndObject();
    }

    public static KeyReleasePolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BinaryData encodedPolicy = null;
            String contentType = null;
            Boolean immutable = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    encodedPolicy = reader.getNullable(nonNullReader -> BinaryData.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    contentType = reader.getString();
                    continue;
                }
                if ("immutable".equals(fieldName)) {
                    immutable = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return new KeyReleasePolicy(encodedPolicy, false).setContentType(contentType).setImmutable(immutable);
        });
    }
}

