/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.exception.HttpResponseException;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.SecretClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.BackupSecretResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.DeletedSecretBundle;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.KeyVaultErrorException;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.SecretBundle;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.SecretsModelsUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.models.DeletedSecret;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.models.SecretProperties;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;

@ServiceClient(builder=SecretClientBuilder.class, serviceInterfaces={SecretClientImpl.SecretClientService.class})
public final class SecretClient {
    private static final ClientLogger LOGGER = new ClientLogger(SecretClient.class);
    private final SecretClientImpl implClient;
    private final String vaultUrl;

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    SecretClient(SecretClientImpl implClient, String vaultUrl) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret setSecret(KeyVaultSecret secret) {
        return this.setSecretWithResponse(secret, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret setSecret(String name, String value) {
        return this.setSecretWithResponse(new KeyVaultSecret(name, value), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> setSecretWithResponse(KeyVaultSecret secret, Context context) {
        return SecretClient.callWithMappedException(() -> {
            SecretProperties secretProperties = secret.getProperties();
            if (secretProperties == null) {
                Response<SecretBundle> response = this.implClient.setSecretWithResponse(this.vaultUrl, secret.getName(), secret.getValue(), null, null, null, context);
                return new SimpleResponse<KeyVaultSecret>(response, SecretsModelsUtils.createKeyVaultSecret(response.getValue()));
            }
            Response<SecretBundle> response = this.implClient.setSecretWithResponse(this.vaultUrl, secret.getName(), secret.getValue(), secretProperties.getTags(), secretProperties.getContentType(), SecretsModelsUtils.createSecretAttributes(secretProperties), context);
            return new SimpleResponse<KeyVaultSecret>(response, SecretsModelsUtils.createKeyVaultSecret(response.getValue()));
        }, SecretAsyncClient::mapSetSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret getSecret(String name) {
        return this.getSecretWithResponse(name, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret getSecret(String name, String version) {
        return this.getSecretWithResponse(name, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> getSecretWithResponse(String name, String version, Context context) {
        if (CoreUtils.isNullOrEmpty(name)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'name' cannot be null or empty."));
        }
        return SecretClient.callWithMappedException(() -> {
            Response<SecretBundle> response = this.implClient.getSecretWithResponse(this.vaultUrl, name, version, context);
            return new SimpleResponse<KeyVaultSecret>(response, SecretsModelsUtils.createKeyVaultSecret(response.getValue()));
        }, SecretAsyncClient::mapGetSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretProperties updateSecretProperties(SecretProperties secretProperties) {
        return this.updateSecretPropertiesWithResponse(secretProperties, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretProperties> updateSecretPropertiesWithResponse(SecretProperties secretProperties, Context context) {
        Response<SecretBundle> response = this.implClient.updateSecretWithResponse(this.vaultUrl, secretProperties.getName(), secretProperties.getVersion(), secretProperties.getContentType(), SecretsModelsUtils.createSecretAttributes(secretProperties), secretProperties.getTags(), context);
        return new SimpleResponse<SecretProperties>(response, SecretsModelsUtils.createSecretProperties(response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedSecret, Void> beginDeleteSecret(String name) {
        return SyncPoller.createPoller(Duration.ofSeconds(1L), this.deleteActivationOperation(name), this.deletePollOperation(name), (context, response) -> null, context -> null);
    }

    private Function<PollingContext<DeletedSecret>, PollResponse<DeletedSecret>> deleteActivationOperation(String name) {
        return pollingContext -> SecretClient.callWithMappedException(() -> new PollResponse<DeletedSecret>(LongRunningOperationStatus.NOT_STARTED, SecretsModelsUtils.createDeletedSecret(this.implClient.deleteSecret(this.vaultUrl, name))), SecretAsyncClient::mapDeleteSecretException);
    }

    private Function<PollingContext<DeletedSecret>, PollResponse<DeletedSecret>> deletePollOperation(String name) {
        return pollingContext -> {
            try {
                return new PollResponse<DeletedSecret>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, SecretsModelsUtils.createDeletedSecret(this.implClient.getDeletedSecret(this.vaultUrl, name)));
            }
            catch (HttpResponseException ex) {
                if (ex.getResponse().getStatusCode() == 404) {
                    return new PollResponse<DeletedSecret>(LongRunningOperationStatus.IN_PROGRESS, (DeletedSecret)pollingContext.getLatestResponse().getValue());
                }
                return new PollResponse<DeletedSecret>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (DeletedSecret)pollingContext.getLatestResponse().getValue());
            }
            catch (Exception ex) {
                return new PollResponse<DeletedSecret>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (DeletedSecret)pollingContext.getLatestResponse().getValue());
            }
        };
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedSecret getDeletedSecret(String name) {
        return this.getDeletedSecretWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedSecret> getDeletedSecretWithResponse(String name, Context context) {
        return SecretClient.callWithMappedException(() -> {
            Response<DeletedSecretBundle> response = this.implClient.getDeletedSecretWithResponse(this.vaultUrl, name, context);
            return new SimpleResponse<DeletedSecret>(response, SecretsModelsUtils.createDeletedSecret(response.getValue()));
        }, SecretAsyncClient::mapGetDeletedSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedSecret(String name) {
        this.purgeDeletedSecretWithResponse(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedSecretWithResponse(String name, Context context) {
        return SecretClient.callWithMappedException(() -> this.implClient.purgeDeletedSecretWithResponse(this.vaultUrl, name, context), SecretAsyncClient::mapPurgeDeletedSecretException);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultSecret, Void> beginRecoverDeletedSecret(String name) {
        return SyncPoller.createPoller(Duration.ofSeconds(1L), this.recoverActivationOperation(name), this.recoverPollOperation(name), (context, response) -> null, context -> null);
    }

    private Function<PollingContext<KeyVaultSecret>, PollResponse<KeyVaultSecret>> recoverActivationOperation(String name) {
        return pollingContext -> SecretClient.callWithMappedException(() -> new PollResponse<KeyVaultSecret>(LongRunningOperationStatus.NOT_STARTED, SecretsModelsUtils.createKeyVaultSecret(this.implClient.recoverDeletedSecret(this.vaultUrl, name))), SecretAsyncClient::mapRecoverDeletedSecretException);
    }

    private Function<PollingContext<KeyVaultSecret>, PollResponse<KeyVaultSecret>> recoverPollOperation(String name) {
        return pollingContext -> {
            try {
                return new PollResponse<KeyVaultSecret>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, SecretsModelsUtils.createKeyVaultSecret(this.implClient.getSecret(this.vaultUrl, name, null)));
            }
            catch (HttpResponseException ex) {
                if (ex.getResponse().getStatusCode() == 404) {
                    return new PollResponse<KeyVaultSecret>(LongRunningOperationStatus.IN_PROGRESS, (KeyVaultSecret)pollingContext.getLatestResponse().getValue());
                }
                return new PollResponse<KeyVaultSecret>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (KeyVaultSecret)pollingContext.getLatestResponse().getValue());
            }
            catch (Exception ex) {
                return new PollResponse<KeyVaultSecret>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (KeyVaultSecret)pollingContext.getLatestResponse().getValue());
            }
        };
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupSecret(String name) {
        return this.backupSecretWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupSecretWithResponse(String name, Context context) {
        return SecretClient.callWithMappedException(() -> {
            Response<BackupSecretResult> response = this.implClient.backupSecretWithResponse(this.vaultUrl, name, context);
            return new SimpleResponse<byte[]>(response, response.getValue().getValue());
        }, SecretAsyncClient::mapBackupSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret restoreSecretBackup(byte[] backup) {
        return this.restoreSecretBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> restoreSecretBackupWithResponse(byte[] backup, Context context) {
        return SecretClient.callWithMappedException(() -> {
            Response<SecretBundle> response = this.implClient.restoreSecretWithResponse(this.vaultUrl, backup, context);
            return new SimpleResponse<KeyVaultSecret>(response, SecretsModelsUtils.createKeyVaultSecret(response.getValue()));
        }, SecretAsyncClient::mapRestoreSecretException);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecrets() {
        return this.listPropertiesOfSecrets(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecrets(Context context) {
        return new PagedIterable<SecretProperties>(maxResults -> SecretAsyncClient.mapSecretItemPage(this.implClient.getSecretsSinglePage(this.vaultUrl, (Integer)maxResults, context)), (continuationToken, maxResults) -> SecretAsyncClient.mapSecretItemPage(this.implClient.getSecretsNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedSecret> listDeletedSecrets() {
        return this.listDeletedSecrets(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedSecret> listDeletedSecrets(Context context) {
        return new PagedIterable<DeletedSecret>(maxResults -> SecretAsyncClient.mapDeletedSecretItemPage(this.implClient.getDeletedSecretsSinglePage(this.vaultUrl, (Integer)maxResults, context)), (continuationToken, maxResults) -> SecretAsyncClient.mapDeletedSecretItemPage(this.implClient.getDeletedSecretsNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecretVersions(String name) {
        return this.listPropertiesOfSecretVersions(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecretVersions(String name, Context context) {
        return new PagedIterable<SecretProperties>(maxResults -> SecretAsyncClient.mapSecretItemPage(this.implClient.getSecretVersionsSinglePage(this.vaultUrl, name, (Integer)maxResults, context)), (continuationToken, maxResults) -> SecretAsyncClient.mapSecretItemPage(this.implClient.getSecretVersionsNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    private static <T> T callWithMappedException(Supplier<T> call, Function<KeyVaultErrorException, HttpResponseException> exceptionMapper) {
        try {
            return call.get();
        }
        catch (KeyVaultErrorException ex) {
            throw exceptionMapper.apply(ex);
        }
    }
}

