/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.SecretItem;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedSecretItem
extends SecretItem {
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;
    private Boolean managed;

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public DeletedSecretItem setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    @Override
    public Boolean isManaged() {
        return this.managed;
    }

    @Override
    public DeletedSecretItem setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public DeletedSecretItem setAttributes(SecretAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    @Override
    public DeletedSecretItem setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public DeletedSecretItem setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeJsonField("attributes", this.getAttributes());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("contentType", this.getContentType());
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedSecretItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedSecretItem deserializedDeletedSecretItem = new DeletedSecretItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeletedSecretItem.setId(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedSecretItem.setAttributes(SecretAttributes.fromJson(reader));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedSecretItem.setTags((Map)tags);
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedDeletedSecretItem.setContentType(reader.getString());
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedDeletedSecretItem.managed = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedSecretItem.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedSecretItem.scheduledPurgeDate = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedSecretItem.deletedDate = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedSecretItem;
        });
    }
}

