/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import java.io.IOException;
import java.util.Map;

public final class SecretUpdateParameters
implements JsonSerializable<SecretUpdateParameters> {
    private String secretContentType;
    private SecretAttributes secretAttributes;
    private Map<String, String> tags;

    public String getSecretContentType() {
        return this.secretContentType;
    }

    public SecretUpdateParameters setSecretContentType(String secretContentType) {
        this.secretContentType = secretContentType;
        return this;
    }

    public SecretAttributes getSecretAttributes() {
        return this.secretAttributes;
    }

    public SecretUpdateParameters setSecretAttributes(SecretAttributes secretAttributes) {
        this.secretAttributes = secretAttributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public SecretUpdateParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.secretContentType);
        jsonWriter.writeJsonField("attributes", this.secretAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static SecretUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretUpdateParameters deserializedSecretUpdateParameters = new SecretUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentType".equals(fieldName)) {
                    deserializedSecretUpdateParameters.secretContentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedSecretUpdateParameters.secretAttributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSecretUpdateParameters.tags = tags;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretUpdateParameters;
        });
    }
}

