/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.UserAgentPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.JacksonAdapter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.AppendBlobsImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.BlobsImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.BlockBlobsImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.ContainersImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.PageBlobsImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.ServicesImpl;

public final class AzureBlobStorageImpl {
    private final String url;
    private final String version;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final ServicesImpl services;
    private final ContainersImpl containers;
    private final BlobsImpl blobs;
    private final PageBlobsImpl pageBlobs;
    private final AppendBlobsImpl appendBlobs;
    private final BlockBlobsImpl blockBlobs;

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ServicesImpl getServices() {
        return this.services;
    }

    public ContainersImpl getContainers() {
        return this.containers;
    }

    public BlobsImpl getBlobs() {
        return this.blobs;
    }

    public PageBlobsImpl getPageBlobs() {
        return this.pageBlobs;
    }

    public AppendBlobsImpl getAppendBlobs() {
        return this.appendBlobs;
    }

    public BlockBlobsImpl getBlockBlobs() {
        return this.blockBlobs;
    }

    public AzureBlobStorageImpl(String url, String version) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(), JacksonAdapter.createDefaultSerializerAdapter(), url, version);
    }

    public AzureBlobStorageImpl(HttpPipeline httpPipeline, String url, String version) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), url, version);
    }

    public AzureBlobStorageImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String url, String version) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.url = url;
        this.version = version;
        this.services = new ServicesImpl(this);
        this.containers = new ContainersImpl(this);
        this.blobs = new BlobsImpl(this);
        this.pageBlobs = new PageBlobsImpl(this);
        this.appendBlobs = new AppendBlobsImpl(this);
        this.blockBlobs = new BlockBlobsImpl(this);
    }
}

