/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerItem;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReader;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobContainersSegment
implements XmlSerializable<BlobContainersSegment> {
    private String serviceEndpoint;
    private String prefix;
    private String marker;
    private Integer maxResults;
    private String nextMarker;
    private List<BlobContainerItem> blobContainerItems;

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public BlobContainersSegment setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public BlobContainersSegment setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public BlobContainersSegment setMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public BlobContainersSegment setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public BlobContainersSegment setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public List<BlobContainerItem> getBlobContainerItems() {
        if (this.blobContainerItems == null) {
            this.blobContainerItems = new ArrayList<BlobContainerItem>();
        }
        return this.blobContainerItems;
    }

    public BlobContainersSegment setBlobContainerItems(List<BlobContainerItem> blobContainerItems) {
        this.blobContainerItems = blobContainerItems;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "EnumerationResults" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringAttribute("ServiceEndpoint", this.serviceEndpoint);
        xmlWriter.writeStringElement("Prefix", this.prefix);
        xmlWriter.writeStringElement("Marker", this.marker);
        xmlWriter.writeNumberElement("MaxResults", this.maxResults);
        xmlWriter.writeStringElement("NextMarker", this.nextMarker);
        if (this.blobContainerItems != null) {
            xmlWriter.writeStartElement("Containers");
            for (BlobContainerItem element : this.blobContainerItems) {
                xmlWriter.writeXml(element, "Container");
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static BlobContainersSegment fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobContainersSegment.fromXml(xmlReader, null);
    }

    public static BlobContainersSegment fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "EnumerationResults" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobContainersSegment deserializedBlobContainersSegment = new BlobContainersSegment();
            deserializedBlobContainersSegment.serviceEndpoint = reader.getStringAttribute(null, "ServiceEndpoint");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Prefix".equals(elementName.getLocalPart())) {
                    deserializedBlobContainersSegment.prefix = reader.getStringElement();
                    continue;
                }
                if ("Marker".equals(elementName.getLocalPart())) {
                    deserializedBlobContainersSegment.marker = reader.getStringElement();
                    continue;
                }
                if ("MaxResults".equals(elementName.getLocalPart())) {
                    deserializedBlobContainersSegment.maxResults = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedBlobContainersSegment.nextMarker = reader.getStringElement();
                    continue;
                }
                if ("Containers".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("Container".equals(elementName.getLocalPart())) {
                            if (deserializedBlobContainersSegment.blobContainerItems == null) {
                                deserializedBlobContainersSegment.blobContainerItems = new ArrayList<BlobContainerItem>();
                            }
                            deserializedBlobContainersSegment.blobContainerItems.add(BlobContainerItem.fromXml(reader, "Container"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobContainersSegment;
        });
    }
}

