/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.PageRange;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReader;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class PageListCollection
implements XmlSerializable<PageRange> {
    private List<PageRange> value = new ArrayList<PageRange>();
    private String nextMarker;

    public List<PageRange> getValue() {
        return this.value;
    }

    public PageListCollection setValue(List<PageRange> value) {
        this.value = value;
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public PageListCollection setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageList" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.value != null) {
            for (PageRange element : this.value) {
                xmlWriter.writeXml(element, "PageRange");
            }
        }
        xmlWriter.writeStringElement("nextMarker", this.nextMarker);
        return xmlWriter.writeEndElement();
    }

    public static PageListCollection fromXml(XmlReader xmlReader) throws XMLStreamException {
        return PageListCollection.fromXml(xmlReader, null);
    }

    public static PageListCollection fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageList" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            PageListCollection deserializedPageListCollection = new PageListCollection();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("PageRange".equals(elementName.getLocalPart())) {
                    if (deserializedPageListCollection.value == null) {
                        deserializedPageListCollection.value = new ArrayList<PageRange>();
                    }
                    deserializedPageListCollection.value.add(PageRange.fromXml(reader, "PageRange"));
                    continue;
                }
                if ("nextMarker".equals(elementName.getLocalPart())) {
                    deserializedPageListCollection.nextMarker = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedPageListCollection;
        });
    }
}

