/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.RequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.ResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.AzureBlobStorageImplBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobsAcquireLeaseHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobsBreakLeaseHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobsChangeLeaseHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobsRenewLeaseHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ContainersAcquireLeaseHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ContainersBreakLeaseHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ContainersChangeLeaseHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ContainersRenewLeaseHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.util.ModelHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobLeaseRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobStorageException;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobAcquireLeaseOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobBreakLeaseOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobChangeLeaseOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobReleaseLeaseOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobRenewLeaseOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlobLeaseClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;
import java.util.concurrent.Callable;

@ServiceClient(builder=BlobLeaseClientBuilder.class)
public final class BlobLeaseClient {
    private final String containerName;
    private final String blobName;
    private final boolean isBlob;
    private final AzureBlobStorageImpl client;
    private final String accountName;
    private volatile String leaseId;

    BlobLeaseClient(HttpPipeline pipeline, String url, String containerName, String blobName, String leaseId, boolean isBlob, String accountName, String serviceVersion) {
        this.isBlob = isBlob;
        this.leaseId = leaseId;
        this.client = new AzureBlobStorageImplBuilder().pipeline(pipeline).url(url).version(serviceVersion).buildClient();
        this.accountName = accountName;
        this.containerName = containerName;
        this.blobName = blobName;
    }

    public String getResourceUrl() {
        if (this.isBlob) {
            return this.client.getUrl() + "/" + this.containerName + "/" + this.blobName;
        }
        return this.client.getUrl() + "/" + this.containerName;
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String acquireLease(int durationInSeconds) {
        return this.acquireLeaseWithResponse(durationInSeconds, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> acquireLeaseWithResponse(int durationInSeconds, RequestConditions modifiedRequestConditions, Duration timeout2, Context context) {
        return this.acquireLeaseWithResponse(new BlobAcquireLeaseOptions(durationInSeconds).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> acquireLeaseWithResponse(BlobAcquireLeaseOptions options, Duration timeout2, Context context) {
        Context finalContext;
        StorageImplUtils.assertNotNull("options", options);
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        Context context2 = finalContext = context == null ? Context.NONE : context;
        if (this.isBlob) {
            Callable<ResponseBase> operation = () -> this.client.getBlobs().acquireLeaseWithResponse(this.containerName, this.blobName, null, options.getDuration(), this.leaseId, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, finalContext);
            ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, BlobStorageException.class);
            this.leaseId = ((BlobsAcquireLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseId();
            return new SimpleResponse<String>(response, ((BlobsAcquireLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseId());
        }
        Callable<ResponseBase> operation = () -> this.client.getContainers().acquireLeaseWithResponse(this.containerName, null, options.getDuration(), this.leaseId, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, BlobStorageException.class);
        this.leaseId = ((ContainersAcquireLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseId();
        return new SimpleResponse<String>(response, ((ContainersAcquireLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseId());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String renewLease() {
        return this.renewLeaseWithResponse((RequestConditions)null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> renewLeaseWithResponse(RequestConditions modifiedRequestConditions, Duration timeout2, Context context) {
        return this.renewLeaseWithResponse(new BlobRenewLeaseOptions().setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> renewLeaseWithResponse(BlobRenewLeaseOptions options, Duration timeout2, Context context) {
        Context finalContext;
        BlobRenewLeaseOptions finalOptions = options == null ? new BlobRenewLeaseOptions() : options;
        BlobLeaseRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new BlobLeaseRequestConditions() : finalOptions.getRequestConditions();
        Context context2 = finalContext = context == null ? Context.NONE : context;
        if (this.isBlob) {
            Callable<ResponseBase> operation = () -> this.client.getBlobs().renewLeaseWithResponse(this.containerName, this.blobName, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, finalContext);
            ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, BlobStorageException.class);
            return new SimpleResponse<String>(response, ((BlobsRenewLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseId());
        }
        Callable<ResponseBase> operation = () -> this.client.getContainers().renewLeaseWithResponse(this.containerName, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, BlobStorageException.class);
        return new SimpleResponse<String>(response, ((ContainersRenewLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseId());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releaseLease() {
        this.releaseLeaseWithResponse((RequestConditions)null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> releaseLeaseWithResponse(RequestConditions modifiedRequestConditions, Duration timeout2, Context context) {
        return this.releaseLeaseWithResponse(new BlobReleaseLeaseOptions().setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> releaseLeaseWithResponse(BlobReleaseLeaseOptions options, Duration timeout2, Context context) {
        BlobReleaseLeaseOptions finalOptions = options == null ? new BlobReleaseLeaseOptions() : options;
        BlobLeaseRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new BlobLeaseRequestConditions() : finalOptions.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = this.isBlob ? () -> this.client.getBlobs().releaseLeaseNoCustomHeadersWithResponse(this.containerName, this.blobName, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, finalContext) : () -> this.client.getContainers().releaseLeaseNoCustomHeadersWithResponse(this.containerName, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, finalContext);
        return StorageImplUtils.sendRequest(operation, timeout2, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Integer breakLease() {
        return this.breakLeaseWithResponse(null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Integer> breakLeaseWithResponse(Integer breakPeriodInSeconds, RequestConditions modifiedRequestConditions, Duration timeout2, Context context) {
        return this.breakLeaseWithResponse(new BlobBreakLeaseOptions().setBreakPeriod(breakPeriodInSeconds == null ? null : Duration.ofSeconds(breakPeriodInSeconds.intValue())).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Integer> breakLeaseWithResponse(BlobBreakLeaseOptions options, Duration timeout2, Context context) {
        Integer breakPeriod;
        BlobBreakLeaseOptions finalOptions = options == null ? new BlobBreakLeaseOptions() : options;
        BlobLeaseRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new BlobLeaseRequestConditions() : finalOptions.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        Integer n = breakPeriod = finalOptions.getBreakPeriod() == null ? null : Integer.valueOf(Math.toIntExact(finalOptions.getBreakPeriod().getSeconds()));
        if (this.isBlob) {
            Callable<ResponseBase> operation = () -> this.client.getBlobs().breakLeaseWithResponse(this.containerName, this.blobName, null, breakPeriod, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, finalContext);
            ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, BlobStorageException.class);
            return new SimpleResponse<Integer>(response, ((BlobsBreakLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseTime());
        }
        Callable<ResponseBase> operation = () -> this.client.getContainers().breakLeaseWithResponse(this.containerName, null, breakPeriod, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, BlobStorageException.class);
        return new SimpleResponse<Integer>(response, ((ContainersBreakLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseTime());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String changeLease(String proposedId) {
        return this.changeLeaseWithResponse(proposedId, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> changeLeaseWithResponse(String proposedId, RequestConditions modifiedRequestConditions, Duration timeout2, Context context) {
        return this.changeLeaseWithResponse(new BlobChangeLeaseOptions(proposedId).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> changeLeaseWithResponse(BlobChangeLeaseOptions options, Duration timeout2, Context context) {
        Context finalContext;
        StorageImplUtils.assertNotNull("options", options);
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        Context context2 = finalContext = context == null ? Context.NONE : context;
        if (this.isBlob) {
            Callable<ResponseBase> operation = () -> this.client.getBlobs().changeLeaseWithResponse(this.containerName, this.blobName, this.leaseId, options.getProposedId(), null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, finalContext);
            ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, BlobStorageException.class);
            this.leaseId = ((BlobsChangeLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseId();
            return new SimpleResponse<String>(response, ((BlobsChangeLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseId());
        }
        Callable<ResponseBase> operation = () -> this.client.getContainers().changeLeaseWithResponse(this.containerName, this.leaseId, options.getProposedId(), null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, BlobStorageException.class);
        this.leaseId = ((ContainersChangeLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseId();
        return new SimpleResponse<String>(response, ((ContainersChangeLeaseHeaders)response.getDeserializedHeaders()).getXMsLeaseId());
    }

    public String getAccountName() {
        return this.accountName;
    }
}

