/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureSasCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.exception.HttpResponseException;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.ResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.SasImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.FileSmbProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareDirectoryClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareFileAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareFileClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.SharePermission;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.ShareSignedIdentifierWrapper;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.SharesCreatePermissionHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.SharesGetAccessPolicyHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.SharesGetPermissionHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.util.ModelHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.FilePermissionFormat;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareDirectoryInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareErrorCode;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareFilePermission;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareSnapshotInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareStatistics;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareStorageException;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareCreateOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareDeleteOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareDirectoryCreateOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareGetAccessPolicyOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareGetPropertiesOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareGetStatisticsOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareSetAccessPolicyOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareSetMetadataOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareSetPropertiesOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;

@ServiceClient(builder=ShareClientBuilder.class)
public class ShareClient {
    private static final ClientLogger LOGGER = new ClientLogger(ShareClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;
    private final String shareUrlString;

    ShareClient(AzureFileStorageImpl azureFileStorageClient, String shareName, String snapshot, String accountName, ShareServiceVersion serviceVersion, AzureSasCredential sasToken) {
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        this.shareName = shareName;
        this.snapshot = snapshot;
        this.accountName = accountName;
        this.azureFileStorageClient = azureFileStorageClient;
        this.serviceVersion = serviceVersion;
        this.sasToken = sasToken;
        StringBuilder shareUrlString = new StringBuilder(azureFileStorageClient.getUrl()).append("/").append(shareName);
        if (snapshot != null) {
            shareUrlString.append("?sharesnapshot=").append(snapshot);
        }
        this.shareUrlString = shareUrlString.toString();
    }

    public String getAccountUrl() {
        return this.azureFileStorageClient.getUrl();
    }

    public String getShareUrl() {
        return this.shareUrlString;
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public ShareDirectoryClient getRootDirectoryClient() {
        return this.getDirectoryClient("");
    }

    public ShareDirectoryClient getDirectoryClient(String directoryName) {
        directoryName = "/".equals(directoryName) ? "" : directoryName;
        return new ShareDirectoryClient(this.azureFileStorageClient, this.shareName, directoryName, this.snapshot, this.accountName, this.serviceVersion, this.sasToken);
    }

    public ShareFileClient getFileClient(String filePath) {
        return new ShareFileClient(new ShareFileAsyncClient(this.azureFileStorageClient, this.shareName, filePath, this.snapshot, this.accountName, this.serviceVersion, this.sasToken), this.azureFileStorageClient, this.shareName, filePath, this.snapshot, this.accountName, this.serviceVersion, this.sasToken);
    }

    public ShareClient getSnapshotClient(String snapshot) {
        return new ShareClient(this.azureFileStorageClient, this.shareName, snapshot, this.accountName, this.serviceVersion, this.sasToken);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Boolean exists() {
        return this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout2, Context context) {
        try {
            Response<ShareProperties> response = this.getPropertiesWithResponse(timeout2, context);
            return new SimpleResponse<Boolean>(response, true);
        }
        catch (RuntimeException e) {
            if (ModelHelper.checkDoesNotExistStatusCode(e) && e instanceof HttpResponseException) {
                HttpResponse response = ((HttpResponseException)e).getResponse();
                return new SimpleResponse<Boolean>(response.getRequest(), response.getStatusCode(), response.getHeaders(), false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo create() {
        return this.createWithResponse(null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> createWithResponse(Map<String, String> metadata, Integer quotaInGB, Duration timeout2, Context context) {
        return this.createWithResponse(new ShareCreateOptions().setQuotaInGb(quotaInGB).setMetadata(metadata), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> createWithResponse(ShareCreateOptions options, Duration timeout2, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareCreateOptions finalOptions = options == null ? new ShareCreateOptions() : options;
        String enabledProtocol = finalOptions.getProtocols() == null ? null : finalOptions.getProtocols().toString();
        String finalEnabledProtocol = "".equals(enabledProtocol) ? null : enabledProtocol;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().createNoCustomHeadersWithResponse(this.shareName, null, finalOptions.getMetadata(), finalOptions.getQuotaInGb(), finalOptions.getAccessTier(), finalEnabledProtocol, finalOptions.getRootSquash(), finalOptions.isSnapshotVirtualDirectoryAccessEnabled(), finalOptions.isPaidBurstingEnabled(), finalOptions.getPaidBurstingMaxBandwidthMibps(), finalOptions.getPaidBurstingMaxIops(), finalOptions.getProvisionedMaxIops(), finalOptions.getProvisionedMaxBandwidthMibps(), finalContext);
        return ModelHelper.mapToShareInfoResponse(StorageImplUtils.sendRequest(operation, timeout2, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo createIfNotExists() {
        return this.createIfNotExistsWithResponse(null, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> createIfNotExistsWithResponse(ShareCreateOptions options, Duration timeout2, Context context) {
        try {
            return this.createWithResponse(options, timeout2, context);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 409 && e.getErrorCode().equals(ShareErrorCode.SHARE_ALREADY_EXISTS)) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse<Object>(res.getRequest(), res.getStatusCode(), res.getHeaders(), null);
            }
            throw LOGGER.logExceptionAsError(e);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareSnapshotInfo createSnapshot() {
        return this.createSnapshotWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareSnapshotInfo> createSnapshotWithResponse(Map<String, String> metadata, Duration timeout2, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getShares().createSnapshotWithResponse(this.shareName, null, metadata, finalContext);
        return ModelHelper.mapCreateSnapshotResponse(StorageImplUtils.sendRequest(operation, timeout2, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Duration timeout2, Context context) {
        return this.deleteWithResponse(new ShareDeleteOptions(), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(ShareDeleteOptions options, Duration timeout2, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareDeleteOptions finalOptions = options == null ? new ShareDeleteOptions() : options;
        ShareRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new ShareRequestConditions() : finalOptions.getRequestConditions();
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().deleteNoCustomHeadersWithResponse(this.shareName, this.snapshot, null, ModelHelper.toDeleteSnapshotsOptionType(finalOptions.getDeleteSnapshotsOptions()), requestConditions.getLeaseId(), finalContext);
        return StorageImplUtils.sendRequest(operation, timeout2, ShareStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return this.deleteIfExistsWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(ShareDeleteOptions options, Duration timeout2, Context context) {
        try {
            Response<Void> response = this.deleteWithResponse(options, timeout2, context);
            return new SimpleResponse<Boolean>(response, true);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 404 && e.getErrorCode().equals(ShareErrorCode.SHARE_NOT_FOUND)) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse<Boolean>(res.getRequest(), res.getStatusCode(), res.getHeaders(), false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareProperties getProperties() {
        return this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareProperties> getPropertiesWithResponse(Duration timeout2, Context context) {
        return this.getPropertiesWithResponse(new ShareGetPropertiesOptions(), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareProperties> getPropertiesWithResponse(ShareGetPropertiesOptions options, Duration timeout2, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getShares().getPropertiesWithResponse(this.shareName, this.snapshot, null, requestConditions.getLeaseId(), finalContext);
        return ModelHelper.mapGetPropertiesResponse(StorageImplUtils.sendRequest(operation, timeout2, ShareStorageException.class));
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo setQuota(int quotaInGB) {
        return this.setQuotaWithResponse(quotaInGB, null, Context.NONE).getValue();
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setQuotaWithResponse(int quotaInGB, Duration timeout2, Context context) {
        return this.setPropertiesWithResponse(new ShareSetPropertiesOptions().setQuotaInGb(quotaInGB), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo setProperties(ShareSetPropertiesOptions options) {
        return this.setPropertiesWithResponse(options, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setPropertiesWithResponse(ShareSetPropertiesOptions options, Duration timeout2, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().setPropertiesNoCustomHeadersWithResponse(this.shareName, null, options.getQuotaInGb(), options.getAccessTier(), requestConditions.getLeaseId(), options.getRootSquash(), options.isSnapshotVirtualDirectoryAccessEnabled(), options.isPaidBurstingEnabled(), options.getPaidBurstingMaxBandwidthMibps(), options.getPaidBurstingMaxIops(), options.getProvisionedMaxIops(), options.getProvisionedMaxBandwidthMibps(), finalContext);
        return ModelHelper.mapToShareInfoResponse(StorageImplUtils.sendRequest(operation, timeout2, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo setMetadata(Map<String, String> metadata) {
        return this.setMetadataWithResponse(metadata, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setMetadataWithResponse(Map<String, String> metadata, Duration timeout2, Context context) {
        return this.setMetadataWithResponse(new ShareSetMetadataOptions().setMetadata(metadata), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setMetadataWithResponse(ShareSetMetadataOptions options, Duration timeout2, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().setMetadataNoCustomHeadersWithResponse(this.shareName, null, options.getMetadata(), requestConditions.getLeaseId(), finalContext);
        return ModelHelper.mapToShareInfoResponse(StorageImplUtils.sendRequest(operation, timeout2, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareSignedIdentifier> getAccessPolicy() {
        return this.getAccessPolicy(new ShareGetAccessPolicyOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareSignedIdentifier> getAccessPolicy(ShareGetAccessPolicyOptions options) {
        ShareGetAccessPolicyOptions finalOptions = options == null ? new ShareGetAccessPolicyOptions() : options;
        ShareRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new ShareRequestConditions() : finalOptions.getRequestConditions();
        ResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifierWrapper> responseBase = this.azureFileStorageClient.getShares().getAccessPolicyWithResponse(this.shareName, null, requestConditions.getLeaseId(), Context.NONE);
        Supplier response = () -> new PagedResponseBase<SharesGetAccessPolicyHeaders, ShareSignedIdentifier>(responseBase.getRequest(), responseBase.getStatusCode(), responseBase.getHeaders(), ((ShareSignedIdentifierWrapper)responseBase.getValue()).items(), null, (SharesGetAccessPolicyHeaders)responseBase.getDeserializedHeaders());
        return new PagedIterable<ShareSignedIdentifier>(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareInfo setAccessPolicy(List<ShareSignedIdentifier> permissions) {
        return this.setAccessPolicyWithResponse(permissions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setAccessPolicyWithResponse(List<ShareSignedIdentifier> permissions, Duration timeout2, Context context) {
        return this.setAccessPolicyWithResponse(new ShareSetAccessPolicyOptions().setPermissions(permissions), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareInfo> setAccessPolicyWithResponse(ShareSetAccessPolicyOptions options, Duration timeout2, Context context) {
        options = options == null ? new ShareSetAccessPolicyOptions() : options;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        List<ShareSignedIdentifier> permissions = ModelHelper.truncateAccessPolicyPermissionsToSeconds(options.getPermissions());
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().setAccessPolicyNoCustomHeadersWithResponse(this.shareName, null, requestConditions.getLeaseId(), permissions, finalContext);
        return ModelHelper.mapToShareInfoResponse(StorageImplUtils.sendRequest(operation, timeout2, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareStatistics getStatistics() {
        return this.getStatisticsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareStatistics> getStatisticsWithResponse(Duration timeout2, Context context) {
        return this.getStatisticsWithResponse(new ShareGetStatisticsOptions(), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareStatistics> getStatisticsWithResponse(ShareGetStatisticsOptions options, Duration timeout2, Context context) {
        options = options == null ? new ShareGetStatisticsOptions() : options;
        ShareRequestConditions requestConditions = options.getRequestConditions() == null ? new ShareRequestConditions() : options.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureFileStorageClient.getShares().getStatisticsNoCustomHeadersWithResponse(this.shareName, null, requestConditions.getLeaseId(), finalContext);
        return ModelHelper.mapGetStatisticsResponse(StorageImplUtils.sendRequest(operation, timeout2, ShareStorageException.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryClient createDirectory(String directoryName) {
        return this.createDirectoryWithResponse(directoryName, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryClient> createDirectoryWithResponse(String directoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout2, Context context) {
        ShareDirectoryClient shareDirectoryClient = this.getDirectoryClient(directoryName);
        return new SimpleResponse<ShareDirectoryClient>(shareDirectoryClient.createWithResponse(smbProperties, filePermission, metadata, timeout2, context), shareDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryClient createDirectoryIfNotExists(String directoryName) {
        return this.createDirectoryIfNotExistsWithResponse(directoryName, new ShareDirectoryCreateOptions(), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryClient> createDirectoryIfNotExistsWithResponse(String directoryName, ShareDirectoryCreateOptions options, Duration timeout2, Context context) {
        ShareDirectoryClient shareDirectoryClient = this.getDirectoryClient(directoryName);
        Response<ShareDirectoryInfo> response = shareDirectoryClient.createIfNotExistsWithResponse(options, timeout2, context);
        return new SimpleResponse<ShareDirectoryClient>(response, shareDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileClient createFile(String fileName, long maxSize) {
        return this.createFileWithResponse(fileName, maxSize, null, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout2, Context context) {
        return this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, null, timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout2, Context context) {
        ShareFileClient shareFileClient = this.getFileClient(fileName);
        return new SimpleResponse<ShareFileClient>(shareFileClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, timeout2, context), shareFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDirectory(String directoryName) {
        this.deleteDirectoryWithResponse(directoryName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDirectoryWithResponse(String directoryName, Duration timeout2, Context context) {
        return this.getDirectoryClient(directoryName).deleteWithResponse(timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteDirectoryIfExists(String directoryName) {
        return this.deleteDirectoryIfExistsWithResponse(directoryName, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteDirectoryIfExistsWithResponse(String directoryName, Duration timeout2, Context context) {
        return this.getDirectoryClient(directoryName).deleteIfExistsWithResponse(timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, Duration timeout2, Context context) {
        return this.deleteFileWithResponse(fileName, null, timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions, Duration timeout2, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteFileIfExists(String fileName) {
        return this.deleteFileIfExistsWithResponse(fileName, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteFileIfExistsWithResponse(String fileName, ShareRequestConditions requestConditions, Duration timeout2, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ShareRequestConditions finalRequestConditions = requestConditions == null ? new ShareRequestConditions() : requestConditions;
        try {
            Response<Void> response = this.deleteFileWithResponse(fileName, finalRequestConditions, timeout2, finalContext);
            return new SimpleResponse<Boolean>(response, true);
        }
        catch (ShareStorageException e) {
            if (e.getStatusCode() == 404 && e.getErrorCode().equals(ShareErrorCode.RESOURCE_NOT_FOUND)) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse<Boolean>(res.getRequest(), res.getStatusCode(), res.getHeaders(), false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String createPermission(String filePermission) {
        return this.createPermissionWithResponse(filePermission, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String createPermission(ShareFilePermission filePermission) {
        return this.createPermissionWithResponse(filePermission, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> createPermissionWithResponse(String filePermission, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        SharePermission sharePermission = new SharePermission().setPermission(filePermission);
        ResponseBase<SharesCreatePermissionHeaders, Void> response = this.azureFileStorageClient.getShares().createPermissionWithResponse(this.shareName, sharePermission, null, finalContext);
        return new SimpleResponse<String>(response, response.getDeserializedHeaders().getXMsFilePermissionKey());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> createPermissionWithResponse(ShareFilePermission filePermission, Duration timeout2, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        SharePermission sharePermission = new SharePermission().setPermission(filePermission.getPermission()).setFormat(filePermission.getPermissionFormat());
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getShares().createPermissionWithResponse(this.shareName, sharePermission, null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, ShareStorageException.class);
        return new SimpleResponse<String>(response, ((SharesCreatePermissionHeaders)response.getDeserializedHeaders()).getXMsFilePermissionKey());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getPermission(String filePermissionKey) {
        return this.getPermissionWithResponse(filePermissionKey, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getPermission(String filePermissionKey, FilePermissionFormat filePermissionFormat) {
        return this.getPermissionWithResponse(filePermissionKey, filePermissionFormat, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getPermissionWithResponse(String filePermissionKey, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        ResponseBase<SharesGetPermissionHeaders, SharePermission> response = this.azureFileStorageClient.getShares().getPermissionWithResponse(this.shareName, filePermissionKey, null, null, finalContext);
        return new SimpleResponse<String>(response, response.getValue().getPermission());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getPermissionWithResponse(String filePermissionKey, FilePermissionFormat filePermissionFormat, Duration timeout2, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureFileStorageClient.getShares().getPermissionWithResponse(this.shareName, filePermissionKey, filePermissionFormat, null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, ShareStorageException.class);
        return new SimpleResponse<String>(response, ((SharePermission)response.getValue()).getPermission());
    }

    public String getSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.generateSas(shareServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return this.generateSas(shareServiceSasSignatureValues, null, context);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName()).generateSas(SasImplUtils.extractSharedKeyCredential(this.getHttpPipeline()), stringToSignHandler, context);
    }
}

