/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share;

import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.StorageInputStream;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareFileAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareFileRange;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareStorageException;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.io.IOException;
import java.nio.ByteBuffer;

public class StorageFileInputStream
extends StorageInputStream {
    private static final ClientLogger LOGGER = new ClientLogger(StorageFileInputStream.class);
    private final ShareFileAsyncClient shareFileAsyncClient;

    StorageFileInputStream(ShareFileAsyncClient shareFileAsyncClient) throws ShareStorageException {
        this(shareFileAsyncClient, 0L, null);
    }

    StorageFileInputStream(ShareFileAsyncClient shareFileAsyncClient, long fileRangeOffset, Long fileRangeLength) throws ShareStorageException {
        super(fileRangeOffset, fileRangeLength, 0x400000, shareFileAsyncClient.getProperties().block().getContentLength());
        this.shareFileAsyncClient = shareFileAsyncClient;
    }

    @Override
    protected synchronized ByteBuffer dispatchRead(int readLength, long offset) {
        try {
            ByteBuffer currentBuffer = (ByteBuffer)this.shareFileAsyncClient.downloadWithResponse(new ShareFileRange(offset, offset + (long)readLength - 1L), false).flatMap(response -> FluxUtil.collectBytesInByteBufferStream((Flux)response.getValue()).map(ByteBuffer::wrap)).block();
            this.bufferSize = readLength;
            this.bufferStartOffset = offset;
            return currentBuffer;
        }
        catch (ShareStorageException e) {
            this.streamFaulted = true;
            this.lastError = new IOException(e);
            throw LOGGER.logExceptionAsError(new RuntimeException(this.lastError.getMessage(), e));
        }
    }
}

