/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.ByteBufferMarkableInputStream;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageSeekableByteChannel;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareFileClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.FileLastWrittenMode;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareFileUploadRangeOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareRequestConditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

class StorageSeekableByteChannelShareFileWriteBehavior
implements StorageSeekableByteChannel.WriteBehavior {
    private static final ClientLogger LOGGER = new ClientLogger(StorageSeekableByteChannelShareFileWriteBehavior.class);
    private final ShareFileClient client;
    private final ShareRequestConditions conditions;
    private final FileLastWrittenMode lastWrittenMode;
    private Long fileSize;

    StorageSeekableByteChannelShareFileWriteBehavior(ShareFileClient client, ShareRequestConditions conditions, FileLastWrittenMode lastWrittenMode) {
        this.client = Objects.requireNonNull(client, "'client' cannot be null.");
        this.conditions = conditions;
        this.lastWrittenMode = lastWrittenMode;
    }

    ShareFileClient getClient() {
        return this.client;
    }

    ShareRequestConditions getRequestConditions() {
        return this.conditions;
    }

    FileLastWrittenMode getLastWrittenMode() {
        return this.lastWrittenMode;
    }

    @Override
    public void write(ByteBuffer src, long destOffset) throws IOException {
        ByteBufferMarkableInputStream uploadStream = new ByteBufferMarkableInputStream(src);
        this.client.uploadRangeWithResponse(new ShareFileUploadRangeOptions(uploadStream, (long)src.remaining()).setOffset(destOffset).setRequestConditions(this.conditions).setLastWrittenMode(this.lastWrittenMode), null, null);
    }

    @Override
    public void commit(long totalLength) {
    }

    @Override
    public void assertCanSeek(long position) {
        if (this.fileSize == null) {
            this.fileSize = this.client.getProperties().getContentLength();
        }
        if (0L <= position && position <= this.fileSize) {
            return;
        }
        throw LOGGER.logExceptionAsError(new UnsupportedOperationException("Cannot seek beyond bounds of file."));
    }

    @Override
    public void resize(long newSize) {
        throw LOGGER.logExceptionAsError(new UnsupportedOperationException("Setting share file size not supported through SeekableByteChannel interface."));
    }
}

