/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.StorageSharedKeyCredential;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.Constants;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.SasImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.TimeAndFormat;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.sas.SasIpRange;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.sas.SasProtocol;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.sas.ShareFileSasPermission;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.sas.ShareSasPermission;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.function.Consumer;

public class ShareSasImplUtil {
    private static final String SAS_FILE_CONSTANT = "f";
    private static final String SAS_SHARE_CONSTANT = "s";
    private static final ClientLogger LOGGER = new ClientLogger(ShareSasImplUtil.class);
    private static final String VERSION = Configuration.getGlobalConfiguration().get("AZURE_STORAGE_SAS_SERVICE_VERSION", ShareServiceVersion.getLatest().getVersion());
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String shareName;
    private String filePath;
    private String resource;
    private String identifier;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;

    public ShareSasImplUtil(ShareServiceSasSignatureValues sasValues, String shareName) {
        this(sasValues, shareName, null);
    }

    public ShareSasImplUtil(ShareServiceSasSignatureValues sasValues, String shareName, String filePath) {
        Objects.requireNonNull(sasValues);
        this.protocol = sasValues.getProtocol();
        this.startTime = sasValues.getStartTime();
        this.expiryTime = sasValues.getExpiryTime();
        this.permissions = sasValues.getPermissions();
        this.sasIpRange = sasValues.getSasIpRange();
        this.shareName = shareName;
        this.filePath = filePath;
        this.identifier = sasValues.getIdentifier();
        this.cacheControl = sasValues.getCacheControl();
        this.contentDisposition = sasValues.getContentDisposition();
        this.contentEncoding = sasValues.getContentEncoding();
        this.contentLanguage = sasValues.getContentLanguage();
        this.contentType = sasValues.getContentType();
    }

    public String generateSas(StorageSharedKeyCredential storageSharedKeyCredentials, Context context) {
        return this.generateSas(storageSharedKeyCredentials, null, context);
    }

    public String generateSas(StorageSharedKeyCredential storageSharedKeyCredentials, Consumer<String> stringToSignHandler, Context context) {
        StorageImplUtils.assertNotNull("storageSharedKeyCredentials", storageSharedKeyCredentials);
        this.ensureState();
        String canonicalName = this.getCanonicalName(storageSharedKeyCredentials.getAccountName());
        String stringToSign = this.stringToSign(canonicalName);
        StorageImplUtils.logStringToSign(LOGGER, stringToSign, context);
        String signature = storageSharedKeyCredentials.computeHmac256(stringToSign);
        if (stringToSignHandler != null) {
            stringToSignHandler.accept(stringToSign);
        }
        return this.encode(signature);
    }

    private String encode(String signature) {
        StringBuilder sb = new StringBuilder();
        SasImplUtils.tryAppendQueryParameter(sb, "sv", VERSION);
        SasImplUtils.tryAppendQueryParameter(sb, "spr", (Object)this.protocol);
        SasImplUtils.tryAppendQueryParameter(sb, "st", SasImplUtils.formatQueryParameterDate(new TimeAndFormat(this.startTime, null)));
        SasImplUtils.tryAppendQueryParameter(sb, "se", SasImplUtils.formatQueryParameterDate(new TimeAndFormat(this.expiryTime, null)));
        SasImplUtils.tryAppendQueryParameter(sb, "sip", this.sasIpRange);
        SasImplUtils.tryAppendQueryParameter(sb, "si", this.identifier);
        SasImplUtils.tryAppendQueryParameter(sb, "sr", this.resource);
        SasImplUtils.tryAppendQueryParameter(sb, "sp", this.permissions);
        SasImplUtils.tryAppendQueryParameter(sb, "sig", signature);
        SasImplUtils.tryAppendQueryParameter(sb, "rscc", this.cacheControl);
        SasImplUtils.tryAppendQueryParameter(sb, "rscd", this.contentDisposition);
        SasImplUtils.tryAppendQueryParameter(sb, "rsce", this.contentEncoding);
        SasImplUtils.tryAppendQueryParameter(sb, "rscl", this.contentLanguage);
        SasImplUtils.tryAppendQueryParameter(sb, "rsct", this.contentType);
        return sb.toString();
    }

    private void ensureState() {
        if (this.identifier == null && (this.expiryTime == null || this.permissions == null)) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("If identifier is not set, expiry time and permissions must be set"));
        }
        this.resource = CoreUtils.isNullOrEmpty(this.filePath) ? SAS_SHARE_CONSTANT : SAS_FILE_CONSTANT;
        if (this.permissions != null) {
            switch (this.resource) {
                case "f": {
                    this.permissions = ShareFileSasPermission.parse(this.permissions).toString();
                    break;
                }
                case "s": {
                    this.permissions = ShareSasPermission.parse(this.permissions).toString();
                    break;
                }
                default: {
                    LOGGER.info("Not re-parsing permissions. Resource type '{}' is unknown.", this.resource);
                }
            }
        }
    }

    private String getCanonicalName(String account) {
        return !CoreUtils.isNullOrEmpty(this.filePath) ? "/file/" + account + "/" + this.shareName + "/" + this.filePath.replace('\\', '/') : "/file/" + account + "/" + this.shareName;
    }

    private String stringToSign(String canonicalName) {
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION == null ? "" : VERSION, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }
}

