/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.specialized;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareAcquireLeaseOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.options.ShareBreakLeaseOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.specialized.ShareLeaseAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.specialized.ShareLeaseClientBuilder;
import java.time.Duration;

@ServiceClient(builder=ShareLeaseClientBuilder.class)
public final class ShareLeaseClient {
    private final ShareLeaseAsyncClient client;

    ShareLeaseClient(ShareLeaseAsyncClient client) {
        this.client = client;
    }

    @Deprecated
    public String getFileUrl() {
        return this.client.getFileUrl();
    }

    public String getResourceUrl() {
        return this.client.getResourceUrl();
    }

    public String getLeaseId() {
        return this.client.getLeaseId();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String acquireLease() {
        return this.acquireLeaseWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> acquireLeaseWithResponse(Duration timeout2, Context context) {
        return this.acquireLeaseWithResponse(new ShareAcquireLeaseOptions(), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> acquireLeaseWithResponse(ShareAcquireLeaseOptions options, Duration timeout2, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.acquireLeaseWithResponse(options, context), timeout2);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releaseLease() {
        this.releaseLeaseWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> releaseLeaseWithResponse(Duration timeout2, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.releaseLeaseWithResponse(context), timeout2);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void breakLease() {
        this.breakLeaseWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> breakLeaseWithResponse(Duration timeout2, Context context) {
        return this.breakLeaseWithResponse(new ShareBreakLeaseOptions(), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> breakLeaseWithResponse(ShareBreakLeaseOptions options, Duration timeout2, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.breakLeaseWithResponse(options, context), timeout2);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String changeLease(String proposedId) {
        return this.changeLeaseWithResponse(proposedId, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> changeLeaseWithResponse(String proposedId, Duration timeout2, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.changeLeaseWithResponse(proposedId, context), timeout2);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String renewLease() {
        return this.renewLeaseWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> renewLeaseWithResponse(Duration timeout2, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.renewLeaseWithResponse(context), timeout2);
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }
}

